/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractUniCollectingGroupByCollectorProcessor;

final class DroolsUniToBiGroupByCollectorProcessor<A, ResultContainer, NewA, NewB>
extends DroolsAbstractUniCollectingGroupByCollectorProcessor<ResultContainer, A, NewA, BiTuple<NewA, NewB>> {
    private final Function<A, NewA> groupKeyMapping;
    private final Supplier<ResultContainer> supplier;
    private final BiFunction<ResultContainer, A, Runnable> accumulator;
    private final Function<ResultContainer, NewB> finisher;

    public DroolsUniToBiGroupByCollectorProcessor(Function<A, NewA> groupKeyMapping, UniConstraintCollector<A, ResultContainer, NewB> collector) {
        this.groupKeyMapping = groupKeyMapping;
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
    }

    @Override
    protected NewA toKey(A a) {
        return this.groupKeyMapping.apply(a);
    }

    @Override
    protected ResultContainer newContainer() {
        return this.supplier.get();
    }

    @Override
    protected Runnable process(A a, ResultContainer container) {
        return this.accumulator.apply(container, a);
    }

    @Override
    protected BiTuple<NewA, NewB> toResult(NewA key, ResultContainer container) {
        return new BiTuple<NewA, NewB>(key, this.finisher.apply(container));
    }
}

