/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.AbstractSolver;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.core.impl.solver.random.RandomFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.termination.Termination;

public class DefaultSolver<Solution_>
extends AbstractSolver<Solution_> {
    protected EnvironmentMode environmentMode;
    protected RandomFactory randomFactory;
    protected BasicPlumbingTermination basicPlumbingTermination;
    protected final AtomicBoolean solving = new AtomicBoolean(false);
    protected final DefaultSolverScope<Solution_> solverScope;

    public DefaultSolver(EnvironmentMode environmentMode, RandomFactory randomFactory, BestSolutionRecaller<Solution_> bestSolutionRecaller, BasicPlumbingTermination basicPlumbingTermination, Termination termination, List<Phase<Solution_>> phaseList, DefaultSolverScope<Solution_> solverScope) {
        super(bestSolutionRecaller, termination, phaseList);
        this.environmentMode = environmentMode;
        this.randomFactory = randomFactory;
        this.basicPlumbingTermination = basicPlumbingTermination;
        this.solverScope = solverScope;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public RandomFactory getRandomFactory() {
        return this.randomFactory;
    }

    @Override
    public InnerScoreDirectorFactory<Solution_> getScoreDirectorFactory() {
        return this.solverScope.getScoreDirector().getScoreDirectorFactory();
    }

    public BestSolutionRecaller<Solution_> getBestSolutionRecaller() {
        return this.bestSolutionRecaller;
    }

    public List<Phase<Solution_>> getPhaseList() {
        return this.phaseList;
    }

    public DefaultSolverScope<Solution_> getSolverScope() {
        return this.solverScope;
    }

    @Override
    public Solution_ getBestSolution() {
        return this.solverScope.getBestSolution();
    }

    @Override
    public Score getBestScore() {
        return this.solverScope.getBestScore();
    }

    @Override
    public String explainBestScore() {
        Solution_ bestSolution = this.solverScope.getBestSolution();
        if (bestSolution == null) {
            return null;
        }
        if (this.solverScope.getSolutionDescriptor().getScore(bestSolution) == null) {
            return null;
        }
        try (ScoreDirector scoreDirector = this.getScoreDirectorFactory().buildScoreDirector();){
            scoreDirector.setWorkingSolution(bestSolution);
            String string = scoreDirector.explainScore();
            return string;
        }
    }

    @Override
    public long getTimeMillisSpent() {
        Long startingSystemTimeMillis = this.solverScope.getStartingSystemTimeMillis();
        if (startingSystemTimeMillis == null) {
            return 0L;
        }
        Long endingSystemTimeMillis = this.solverScope.getEndingSystemTimeMillis();
        if (endingSystemTimeMillis == null) {
            endingSystemTimeMillis = System.currentTimeMillis();
        }
        return endingSystemTimeMillis - startingSystemTimeMillis;
    }

    @Override
    public boolean isSolving() {
        return this.solving.get();
    }

    @Override
    public boolean terminateEarly() {
        boolean terminationEarlySuccessful = this.basicPlumbingTermination.terminateEarly();
        if (terminationEarlySuccessful) {
            this.logger.info("Terminating solver early.");
        }
        return terminationEarlySuccessful;
    }

    @Override
    public boolean isTerminateEarly() {
        return this.basicPlumbingTermination.isTerminateEarly();
    }

    @Override
    public boolean addProblemFactChange(ProblemFactChange<Solution_> problemFactChange) {
        return this.basicPlumbingTermination.addProblemFactChange(problemFactChange);
    }

    @Override
    public boolean addProblemFactChanges(List<ProblemFactChange<Solution_>> problemFactChangeList) {
        return this.basicPlumbingTermination.addProblemFactChanges(problemFactChangeList);
    }

    @Override
    public boolean isEveryProblemFactChangeProcessed() {
        return this.basicPlumbingTermination.isEveryProblemFactChangeProcessed();
    }

    @Override
    public final Solution_ solve(Solution_ problem) {
        if (problem == null) {
            throw new IllegalArgumentException("The problem (" + problem + ") must not be null.");
        }
        this.solverScope.setBestSolution(problem);
        this.outerSolvingStarted(this.solverScope);
        boolean restartSolver = true;
        while (restartSolver) {
            this.solvingStarted(this.solverScope);
            this.runPhases(this.solverScope);
            this.solvingEnded(this.solverScope);
            restartSolver = this.checkProblemFactChanges();
        }
        this.outerSolvingEnded(this.solverScope);
        return this.solverScope.getBestSolution();
    }

    public void outerSolvingStarted(DefaultSolverScope<Solution_> solverScope) {
        this.solving.set(true);
        this.basicPlumbingTermination.resetTerminateEarly();
        solverScope.setStartingSolverCount(0);
        solverScope.setWorkingRandom(this.randomFactory.createRandom());
    }

    @Override
    public void solvingStarted(DefaultSolverScope<Solution_> solverScope) {
        solverScope.startingNow();
        solverScope.getScoreDirector().resetCalculationCount();
        super.solvingStarted(solverScope);
        int startingSolverCount = solverScope.getStartingSolverCount() + 1;
        solverScope.setStartingSolverCount(startingSolverCount);
        this.logger.info("Solving {}: time spent ({}), best score ({}), environment mode ({}), random ({}).", new Object[]{startingSolverCount == 1 ? "started" : "restarted", solverScope.calculateTimeMillisSpentUpToNow(), solverScope.getBestScore(), this.environmentMode.name(), this.randomFactory != null ? this.randomFactory : "not fixed"});
    }

    @Override
    public void solvingEnded(DefaultSolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        solverScope.endingNow();
    }

    public void outerSolvingEnded(DefaultSolverScope<Solution_> solverScope) {
        solverScope.getScoreDirector().close();
        this.logger.info("Solving ended: time spent ({}), best score ({}), score calculation speed ({}/sec), phase total ({}), environment mode ({}).", new Object[]{solverScope.getTimeMillisSpent(), solverScope.getBestScore(), solverScope.getScoreCalculationSpeed(), this.phaseList.size(), this.environmentMode.name()});
        this.solving.set(false);
    }

    private boolean checkProblemFactChanges() {
        boolean restartSolver = this.basicPlumbingTermination.waitForRestartSolverDecision();
        if (!restartSolver) {
            return false;
        }
        BlockingQueue<ProblemFactChange> problemFactChangeQueue = this.basicPlumbingTermination.startProblemFactChangesProcessing();
        this.solverScope.setWorkingSolutionFromBestSolution();
        Score score = null;
        int stepIndex = 0;
        ProblemFactChange problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
        while (problemFactChange != null) {
            score = this.doProblemFactChange(problemFactChange, stepIndex);
            ++stepIndex;
            problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
        }
        this.basicPlumbingTermination.endProblemFactChangesProcessing();
        this.bestSolutionRecaller.updateBestSolution(this.solverScope);
        this.logger.info("Real-time problem fact changes done: step total ({}), new best score ({}).", (Object)stepIndex, (Object)score);
        return true;
    }

    private Score doProblemFactChange(ProblemFactChange<Solution_> problemFactChange, int stepIndex) {
        problemFactChange.doChange(this.solverScope.getScoreDirector());
        Score score = this.solverScope.calculateScore();
        this.logger.debug("    Step index ({}), new score ({}) for real-time problem fact change.", (Object)stepIndex, (Object)score);
        return score;
    }
}

