/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.lookup.ClassAndPlanningIdComparator;
import org.optaplanner.core.impl.domain.lookup.LookUpManager;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerSupport;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<Solution_, Factory_ extends AbstractScoreDirectorFactory<Solution_>>
implements InnerScoreDirector<Solution_>,
Cloneable {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Factory_ scoreDirectorFactory;
    protected final boolean lookUpEnabled;
    protected final LookUpManager lookUpManager;
    protected boolean constraintMatchEnabledPreference;
    protected final VariableListenerSupport<Solution_> variableListenerSupport;
    protected Solution_ workingSolution;
    protected long workingEntityListRevision = 0L;
    protected Integer workingInitScore = null;
    protected boolean allChangesWillBeUndoneBeforeStepEnds = false;
    protected long calculationCount = 0L;

    protected AbstractScoreDirector(Factory_ scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.lookUpEnabled = lookUpEnabled;
        this.lookUpManager = lookUpEnabled ? new LookUpManager(((AbstractScoreDirectorFactory)scoreDirectorFactory).getSolutionDescriptor().getLookUpStrategyResolver()) : null;
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
        this.variableListenerSupport = new VariableListenerSupport(this);
        this.variableListenerSupport.linkVariableListeners();
    }

    public Factory_ getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    public boolean isLookUpEnabled() {
        return this.lookUpEnabled;
    }

    public boolean isConstraintMatchEnabledPreference() {
        return this.constraintMatchEnabledPreference;
    }

    @Override
    public void overwriteConstraintMatchEnabledPreference(boolean constraintMatchEnabledPreference) {
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
    }

    @Override
    public Solution_ getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public long getWorkingEntityListRevision() {
        return this.workingEntityListRevision;
    }

    public boolean isAllChangesWillBeUndoneBeforeStepEnds() {
        return this.allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean allChangesWillBeUndoneBeforeStepEnds) {
        this.allChangesWillBeUndoneBeforeStepEnds = allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public long getCalculationCount() {
        return this.calculationCount;
    }

    @Override
    public void resetCalculationCount() {
        this.calculationCount = 0L;
    }

    @Override
    public SupplyManager getSupplyManager() {
        return this.variableListenerSupport;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        this.workingSolution = workingSolution;
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        this.workingInitScore = -solutionDescriptor.countUninitializedVariables(workingSolution);
        if (this.lookUpEnabled) {
            this.lookUpManager.resetWorkingObjects(solutionDescriptor.getAllFacts(workingSolution));
        }
        this.variableListenerSupport.resetWorkingSolution();
        this.setWorkingEntityListDirty();
    }

    @Override
    public boolean isWorkingEntityListDirty(long expectedWorkingEntityListRevision) {
        return this.workingEntityListRevision != expectedWorkingEntityListRevision;
    }

    protected void setWorkingEntityListDirty() {
        ++this.workingEntityListRevision;
    }

    @Override
    public Solution_ cloneWorkingSolution() {
        return this.cloneSolution(this.workingSolution);
    }

    @Override
    public Solution_ cloneSolution(Solution_ originalSolution) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Score originalScore = solutionDescriptor.getScore(originalSolution);
        Solution_ cloneSolution = solutionDescriptor.getSolutionCloner().cloneSolution(originalSolution);
        Score cloneScore = solutionDescriptor.getScore(cloneSolution);
        if (((AbstractScoreDirectorFactory)this.scoreDirectorFactory).isAssertClonedSolution()) {
            if (!Objects.equals(originalScore, cloneScore)) {
                throw new IllegalStateException("Cloning corruption: the original's score (" + originalScore + ") is different from the clone's score (" + cloneScore + ").\nCheck the " + SolutionCloner.class.getSimpleName() + ".");
            }
            List<Object> originalEntityList = solutionDescriptor.getEntityList(originalSolution);
            IdentityHashMap originalEntityMap = new IdentityHashMap(originalEntityList.size());
            for (Object originalEntity : originalEntityList) {
                originalEntityMap.put(originalEntity, null);
            }
            for (Object cloneEntity : solutionDescriptor.getEntityList(cloneSolution)) {
                if (!originalEntityMap.containsKey(cloneEntity)) continue;
                throw new IllegalStateException("Cloning corruption: the same entity (" + cloneEntity + ") is present in both the original and the clone.\nSo when a planning variable in the original solution changes, the cloned solution will change too.\nCheck the " + SolutionCloner.class.getSimpleName() + ".");
            }
        }
        return cloneSolution;
    }

    @Override
    public int getWorkingEntityCount() {
        return this.getSolutionDescriptor().getEntityCount(this.workingSolution);
    }

    @Override
    public List<Object> getWorkingEntityList() {
        return this.getSolutionDescriptor().getEntityList(this.workingSolution);
    }

    @Override
    public int getWorkingValueCount() {
        return this.getSolutionDescriptor().getValueCount(this.workingSolution);
    }

    @Override
    public void triggerVariableListeners() {
        this.variableListenerSupport.triggerVariableListenersInNotificationQueues();
    }

    protected void setCalculatedScore(Score score) {
        this.getSolutionDescriptor().setScore(this.workingSolution, score);
        ++this.calculationCount;
    }

    public AbstractScoreDirector<Solution_, Factory_> clone() {
        AbstractScoreDirector clone = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(this.isLookUpEnabled(), this.constraintMatchEnabledPreference);
        clone.setWorkingSolution(this.cloneWorkingSolution());
        return clone;
    }

    @Override
    public InnerScoreDirector<Solution_> createChildThreadScoreDirector(ChildThreadType childThreadType) {
        AbstractScoreDirector childThreadScoreDirector = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(false, this.constraintMatchEnabledPreference);
        if (childThreadType != ChildThreadType.PART_THREAD) {
            throw new IllegalStateException("The childThreadType (" + (Object)((Object)childThreadType) + ") is not implemented.");
        }
        childThreadScoreDirector.calculationCount = this.calculationCount;
        return childThreadScoreDirector;
    }

    @Override
    public void close() {
        this.workingSolution = null;
        this.workingInitScore = null;
        if (this.lookUpEnabled) {
            this.lookUpManager.clearWorkingObjects();
        }
        this.variableListenerSupport.clearWorkingSolution();
    }

    @Override
    public final void beforeEntityAdded(Object entity) {
        this.beforeEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityAdded(Object entity) {
        this.afterEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void beforeVariableChanged(Object entity, String variableName) {
        VariableDescriptor<Solution_> variableDescriptor = this.getSolutionDescriptor().findVariableDescriptorOrFail(entity, variableName);
        this.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final void afterVariableChanged(Object entity, String variableName) {
        VariableDescriptor<Solution_> variableDescriptor = this.getSolutionDescriptor().findVariableDescriptorOrFail(entity, variableName);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final void beforeEntityRemoved(Object entity) {
        this.beforeEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityRemoved(Object entity) {
        this.afterEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.variableListenerSupport.beforeEntityAdded(entityDescriptor, entity);
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore = this.workingInitScore - entityDescriptor.countUninitializedVariables(entity);
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(entity);
        }
        this.variableListenerSupport.afterEntityAdded(entityDescriptor, entity);
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            Integer n = this.workingInitScore;
            Integer n2 = this.workingInitScore = Integer.valueOf(this.workingInitScore + 1);
        }
        this.variableListenerSupport.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            Integer n = this.workingInitScore;
            Integer n2 = this.workingInitScore = Integer.valueOf(this.workingInitScore - 1);
        }
        this.variableListenerSupport.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void changeVariableFacade(VariableDescriptor variableDescriptor, Object entity, Object newValue) {
        this.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore = this.workingInitScore + entityDescriptor.countUninitializedVariables(entity);
        this.variableListenerSupport.beforeEntityRemoved(entityDescriptor, entity);
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(entity);
        }
        this.variableListenerSupport.afterEntityRemoved(entityDescriptor, entity);
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void beforeProblemPropertyChanged(Object problemFactOrEntity) {
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public <E> E lookUpWorkingObject(E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (" + this.lookUpEnabled + ") is disabled in the constructor, this method should not be called.");
        }
        return this.lookUpManager.lookUpWorkingObject(externalObject);
    }

    @Override
    public void assertExpectedWorkingScore(Score expectedWorkingScore, Object completedAction) {
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("Score corruption: the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ") after completedAction (" + completedAction + ").");
        }
    }

    @Override
    public void assertShadowVariablesAreNotStale(Score expectedWorkingScore, Object completedAction) {
        Map<ShadowVariableDescriptor<Solution_>, Object> shadowVariableValuesMap;
        Collection<ShadowVariableDescriptor<Solution_>> shadowVariableDescriptors;
        EntityDescriptor<Solution_> entityDescriptor;
        Object entity;
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        IdentityHashMap entityToShadowVariableValuesMap = new IdentityHashMap();
        Iterator<Object> it = solutionDescriptor.extractAllEntitiesIterator(this.workingSolution);
        while (it.hasNext()) {
            entity = it.next();
            entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            shadowVariableDescriptors = entityDescriptor.getShadowVariableDescriptors();
            shadowVariableValuesMap = new HashMap(shadowVariableDescriptors.size());
            for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor : shadowVariableDescriptors) {
                Object value = shadowVariableDescriptor.getValue(entity);
                shadowVariableValuesMap.put(shadowVariableDescriptor, value);
            }
            entityToShadowVariableValuesMap.put(entity, shadowVariableValuesMap);
        }
        this.variableListenerSupport.triggerAllVariableListeners();
        it = solutionDescriptor.extractAllEntitiesIterator(this.workingSolution);
        while (it.hasNext()) {
            entity = it.next();
            entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            shadowVariableDescriptors = entityDescriptor.getShadowVariableDescriptors();
            shadowVariableValuesMap = (Map)entityToShadowVariableValuesMap.get(entity);
            for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor : shadowVariableDescriptors) {
                Object newValue = shadowVariableDescriptor.getValue(entity);
                Object originalValue = shadowVariableValuesMap.get(shadowVariableDescriptor);
                if (Objects.equals(originalValue, newValue)) continue;
                throw new IllegalStateException(VariableListener.class.getSimpleName() + " corruption: the entity (" + entity + ")'s shadow variable (" + shadowVariableDescriptor.getSimpleEntityAndVariableName() + ")'s corrupted value (" + originalValue + ") changed to uncorrupted value (" + newValue + ") after all " + VariableListener.class.getSimpleName() + "s were triggered without changes to the genuine variables.\nMaybe the " + VariableListener.class.getSimpleName() + " class (" + shadowVariableDescriptor.getVariableListenerClass().getSimpleName() + ") for that shadow variable (" + shadowVariableDescriptor.getSimpleEntityAndVariableName() + ") forgot to update it when one of its sources changed after completedAction (" + completedAction + ").");
            }
        }
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            this.assertWorkingScoreFromScratch(workingScore, "assertShadowVariablesAreNotStale(" + expectedWorkingScore + ", " + completedAction + ")");
            throw new IllegalStateException("Impossible " + VariableListener.class.getSimpleName() + " corruption: the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ") after all " + VariableListener.class.getSimpleName() + "s were triggered without changes to the genuine variables after completedAction (" + completedAction + ").\nBut all the shadow variable values are still the same, so this is impossible.\nMaybe run with " + (Object)((Object)EnvironmentMode.FULL_ASSERT) + " if you aren't already, to fail earlier.");
        }
    }

    @Override
    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        InnerScoreDirectorFactory<Object> assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        try (InnerScoreDirector<Solution_> uncorruptedScoreDirector = assertionScoreDirectorFactory.buildScoreDirector(false, true);){
            uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
            Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
            if (!workingScore.equals(uncorruptedScore)) {
                String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector);
                throw new IllegalStateException("Score corruption: the workingScore (" + workingScore + ") is not the uncorruptedScore (" + uncorruptedScore + ") after completedAction (" + completedAction + "):\n" + scoreCorruptionAnalysis);
            }
        }
    }

    protected String buildScoreCorruptionAnalysis(ScoreDirector<Solution_> uncorruptedScoreDirector) {
        int count;
        if (!this.isConstraintMatchEnabled() || !uncorruptedScoreDirector.isConstraintMatchEnabled()) {
            return "  Score corruption analysis could not be generated because either corrupted constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") or uncorrupted constraintMatchEnabled (" + uncorruptedScoreDirector.isConstraintMatchEnabled() + ") is disabled.\n  Check your score constraints manually.";
        }
        Collection<ConstraintMatchTotal> corruptedConstraintMatchTotals = this.getConstraintMatchTotals();
        Collection<ConstraintMatchTotal> uncorruptedConstraintMatchTotals = uncorruptedScoreDirector.getConstraintMatchTotals();
        ClassAndPlanningIdComparator comparator = new ClassAndPlanningIdComparator(false);
        for (ConstraintMatchTotal constraintMatchTotal : corruptedConstraintMatchTotals) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                constraintMatch.getJustificationList().sort(comparator);
            }
        }
        for (ConstraintMatchTotal constraintMatchTotal : uncorruptedConstraintMatchTotals) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                constraintMatch.getJustificationList().sort(comparator);
            }
        }
        Map<List<Object>, ConstraintMatch> corruptedMap = this.createConstraintMatchMap(corruptedConstraintMatchTotals);
        LinkedHashMap<List<Object>, ConstraintMatch> excessMap = new LinkedHashMap<List<Object>, ConstraintMatch>(corruptedMap);
        Map<List<Object>, ConstraintMatch> missingMap = this.createConstraintMatchMap(uncorruptedConstraintMatchTotals);
        excessMap.keySet().removeAll(missingMap.keySet());
        missingMap.keySet().removeAll(corruptedMap.keySet());
        int CONSTRAINT_MATCH_DISPLAY_LIMIT = 8;
        StringBuilder analysis = new StringBuilder();
        if (excessMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) which are in excess.\n");
        } else {
            analysis.append("  The corrupted scoreDirector has ").append(excessMap.size()).append(" ConstraintMatch(s) which are in excess (and should not be there):\n");
            count = 0;
            for (ConstraintMatch constraintMatch : excessMap.values()) {
                if (count >= 8) {
                    analysis.append("    ... ").append(excessMap.size() - 8).append(" more\n");
                    break;
                }
                analysis.append("    ").append(constraintMatch).append("\n");
                ++count;
            }
        }
        if (missingMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) which are missing.\n");
        } else {
            analysis.append("  The corrupted scoreDirector has ").append(missingMap.size()).append(" ConstraintMatch(s) which are missing:\n");
            count = 0;
            for (ConstraintMatch constraintMatch : missingMap.values()) {
                if (count >= 8) {
                    analysis.append("    ... ").append(missingMap.size() - 8).append(" more\n");
                    break;
                }
                analysis.append("    ").append(constraintMatch).append("\n");
                ++count;
            }
        }
        if (excessMap.isEmpty() && missingMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) in excess or missing. That could be a bug in this class (").append(this.getClass()).append(").\n");
        }
        analysis.append("  Check your score constraints.");
        return analysis.toString();
    }

    private Map<List<Object>, ConstraintMatch> createConstraintMatchMap(Collection<ConstraintMatchTotal> constraintMatchTotals) {
        LinkedHashMap<List<Object>, ConstraintMatch> constraintMatchMap = new LinkedHashMap<List<Object>, ConstraintMatch>(constraintMatchTotals.size() * 16);
        for (ConstraintMatchTotal constraintMatchTotal : constraintMatchTotals) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                ConstraintMatch previousConstraintMatch = constraintMatchMap.put(Arrays.asList(constraintMatchTotal.getConstraintPackage(), constraintMatchTotal.getConstraintName(), constraintMatch.getJustificationList(), constraintMatch.getScore()), constraintMatch);
                if (previousConstraintMatch == null) continue;
                throw new IllegalStateException("Score corruption because the constraintMatch (" + constraintMatch + ") was added twice for constraintMatchTotal (" + constraintMatchTotal + ") without removal.");
            }
        }
        return constraintMatchMap;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculationCount + ")";
    }
}

