/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.fact;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenValueFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenValueProvider;

public class TestGenFactField
implements Comparable<TestGenFactField> {
    private final TestGenValueFact fact;
    private final String propertyName;
    private final Method setter;
    private final TestGenValueProvider<?> valueProvider;
    private boolean active = true;

    TestGenFactField(TestGenValueFact fact, String propertyName, TestGenValueProvider<?> valueProvider) {
        this.fact = fact;
        this.propertyName = propertyName;
        this.valueProvider = valueProvider;
        this.setter = ReflectionHelper.getSetterMethod(fact.getInstance().getClass(), propertyName);
        if (this.setter == null) {
            throw new IllegalStateException("Setter for '" + fact.getInstance().getClass().getSimpleName() + "." + propertyName + "' not found!");
        }
    }

    void reset() {
        Object value = this.active ? this.valueProvider.get() : this.valueProvider.getUninitialized();
        try {
            this.setter.invoke(this.fact.getInstance(), value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to reset " + this.fact.getInstance().getClass().getSimpleName() + "." + this.propertyName, ex);
        }
    }

    public List<Class<?>> getImports() {
        return this.valueProvider.getImports();
    }

    public List<TestGenFact> getRequiredFacts() {
        return this.valueProvider.getRequiredFacts();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    void print(StringBuilder sb) {
        if (this.active) {
            this.valueProvider.printSetup(sb);
            if (this.valueProvider.get() != null) {
                sb.append(String.format("        %s.%s(%s);\n", this.fact.getVariableName(), this.setter.getName(), this.valueProvider.toString()));
            }
        }
    }

    @Override
    public int compareTo(TestGenFactField o) {
        return this.propertyName.compareTo(o.propertyName);
    }
}

