/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByCollectorProcessor;

public abstract class DroolsAbstractBiCollectingGroupByCollectorProcessor<ResultContainer1, ResultContainer2, InTuple, KeyTuple, OutTuple>
extends DroolsAbstractGroupByCollectorProcessor<InTuple, KeyTuple, OutTuple> {
    private final Map<KeyTuple, ResultContainer1> containersMap1 = new HashMap<KeyTuple, ResultContainer1>(0);
    private final Map<KeyTuple, ResultContainer2> containersMap2 = new HashMap<KeyTuple, ResultContainer2>(0);
    private final Map<KeyTuple, OutTuple> resultMap = new LinkedHashMap<KeyTuple, OutTuple>(0);

    @Override
    public Runnable accumulate(InTuple input) {
        KeyTuple key = this.toKey(input);
        Object container1 = this.containersMap1.computeIfAbsent(key, __ -> this.newFirstContainer());
        Object container2 = this.containersMap2.computeIfAbsent(key, __ -> this.newSecondContainer());
        Runnable undo1 = this.processFirst(input, container1);
        Runnable undo2 = this.processSecond(input, container2);
        this.addTuple(key);
        return () -> {
            undo1.run();
            undo2.run();
            long currentCount = this.removeTuple(key);
            if (currentCount == 0L) {
                this.containersMap1.remove(key);
                this.containersMap2.remove(key);
                this.resultMap.remove(key);
            }
        };
    }

    @Override
    public Collection<OutTuple> finish() {
        Set dirtyTupleSet = this.clearDirtyTupleSet();
        if (!dirtyTupleSet.isEmpty()) {
            for (Object tuple : dirtyTupleSet) {
                this.resultMap.put(tuple, this.toResult(tuple, this.containersMap1.get(tuple), this.containersMap2.get(tuple)));
            }
        }
        return this.resultMap.values();
    }

    protected abstract KeyTuple toKey(InTuple var1);

    protected abstract ResultContainer1 newFirstContainer();

    protected abstract ResultContainer2 newSecondContainer();

    protected abstract Runnable processFirst(InTuple var1, ResultContainer1 var2);

    protected abstract Runnable processSecond(InTuple var1, ResultContainer2 var2);

    protected abstract OutTuple toResult(KeyTuple var1, ResultContainer1 var2, ResultContainer2 var3);
}

