/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import java.util.Arrays;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class BendableScoreHolder
extends AbstractScoreHolder {
    private int[] hardScores;
    private int[] softScores;

    public BendableScoreHolder(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled, BendableScore.zero(hardLevelsSize, softLevelsSize));
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public int getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public int getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardLevel, int weight) {
        int n = hardLevel;
        this.hardScores[n] = this.hardScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = hardLevel;
            this.hardScores[n] = this.hardScores[n] - weight;
        }, () -> {
            int[] newHardScores = new int[this.hardScores.length];
            int[] newSoftScores = new int[this.softScores.length];
            newHardScores[hardLevel] = weight;
            return BendableScore.valueOf(newHardScores, newSoftScores);
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softLevel, int weight) {
        int n = softLevel;
        this.softScores[n] = this.softScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = softLevel;
            this.softScores[n] = this.softScores[n] - weight;
        }, () -> {
            int[] newHardScores = new int[this.hardScores.length];
            int[] newSoftScores = new int[this.softScores.length];
            newSoftScores[softLevel] = weight;
            return BendableScore.valueOf(newHardScores, newSoftScores);
        });
    }

    public void addMultiConstraintMatch(RuleContext kcontext, int[] hardWeights, int[] softWeights) {
        int i;
        if (this.hardScores.length != hardWeights.length) {
            throw new IllegalArgumentException("The hardScores length (" + this.hardScores.length + ") is different than the hardWeights length (" + hardWeights.length + ").");
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            int n = i;
            this.hardScores[n] = this.hardScores[n] + hardWeights[i];
        }
        if (this.softScores.length != softWeights.length) {
            throw new IllegalArgumentException("The softScores length (" + this.softScores.length + ") is different than the softWeights length (" + softWeights.length + ").");
        }
        for (i = 0; i < this.softScores.length; ++i) {
            int n = i;
            this.softScores[n] = this.softScores[n] + softWeights[i];
        }
        this.registerConstraintMatch(kcontext, () -> {
            int i;
            for (i = 0; i < this.hardScores.length; ++i) {
                int n = i;
                this.hardScores[n] = this.hardScores[n] - hardWeights[i];
            }
            for (i = 0; i < this.softScores.length; ++i) {
                int n = i;
                this.softScores[n] = this.softScores[n] - softWeights[i];
            }
        }, () -> BendableScore.valueOf(hardWeights, softWeights));
    }

    @Override
    public Score extractScore(int initScore) {
        return new BendableScore(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

