/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.optaplanner.core.api.score.AbstractScore;

public final class HardMediumSoftBigDecimalScore
extends AbstractScore<HardMediumSoftBigDecimalScore> {
    public static final HardMediumSoftBigDecimalScore ZERO = new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    public static final HardMediumSoftBigDecimalScore ONE_HARD = new HardMediumSoftBigDecimalScore(0, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
    public static final HardMediumSoftBigDecimalScore ONE_MEDIUM = new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO);
    public static final HardMediumSoftBigDecimalScore ONE_SOFT = new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE);
    private static final String HARD_LABEL = "hard";
    private static final String MEDIUM_LABEL = "medium";
    private static final String SOFT_LABEL = "soft";
    private final BigDecimal hardScore;
    private final BigDecimal mediumScore;
    private final BigDecimal softScore;

    public static HardMediumSoftBigDecimalScore parseScore(String scoreString) {
        String[] scoreTokens = HardMediumSoftBigDecimalScore.parseScoreTokens(HardMediumSoftBigDecimalScore.class, scoreString, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
        int initScore = HardMediumSoftBigDecimalScore.parseInitScore(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[0]);
        BigDecimal hardScore = HardMediumSoftBigDecimalScore.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[1]);
        BigDecimal mediumScore = HardMediumSoftBigDecimalScore.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[2]);
        BigDecimal softScore = HardMediumSoftBigDecimalScore.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftBigDecimalScore.ofUninitialized(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftBigDecimalScore ofUninitialized(int initScore, BigDecimal hardScore, BigDecimal mediumScore, BigDecimal softScore) {
        return new HardMediumSoftBigDecimalScore(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftBigDecimalScore of(BigDecimal hardScore, BigDecimal mediumScore, BigDecimal softScore) {
        return new HardMediumSoftBigDecimalScore(0, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftBigDecimalScore ofHard(BigDecimal hardScore) {
        return new HardMediumSoftBigDecimalScore(0, hardScore, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public static HardMediumSoftBigDecimalScore ofMedium(BigDecimal mediumScore) {
        return new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, mediumScore, BigDecimal.ZERO);
    }

    public static HardMediumSoftBigDecimalScore ofSoft(BigDecimal softScore) {
        return new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO, softScore);
    }

    private HardMediumSoftBigDecimalScore() {
        super(Integer.MIN_VALUE);
        this.hardScore = null;
        this.mediumScore = null;
        this.softScore = null;
    }

    private HardMediumSoftBigDecimalScore(int initScore, BigDecimal hardScore, BigDecimal mediumScore, BigDecimal softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getMediumScore() {
        return this.mediumScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardMediumSoftBigDecimalScore withInitScore(int newInitScore) {
        return new HardMediumSoftBigDecimalScore(newInitScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore.compareTo(BigDecimal.ZERO) >= 0;
    }

    @Override
    public HardMediumSoftBigDecimalScore add(HardMediumSoftBigDecimalScore addend) {
        return new HardMediumSoftBigDecimalScore(this.initScore + addend.getInitScore(), this.hardScore.add(addend.getHardScore()), this.mediumScore.add(addend.getMediumScore()), this.softScore.add(addend.getSoftScore()));
    }

    @Override
    public HardMediumSoftBigDecimalScore subtract(HardMediumSoftBigDecimalScore subtrahend) {
        return new HardMediumSoftBigDecimalScore(this.initScore - subtrahend.getInitScore(), this.hardScore.subtract(subtrahend.getHardScore()), this.mediumScore.subtract(subtrahend.getMediumScore()), this.softScore.subtract(subtrahend.getSoftScore()));
    }

    @Override
    public HardMediumSoftBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return new HardMediumSoftBigDecimalScore((int)Math.floor((double)this.initScore * multiplicand), this.hardScore.multiply(multiplicandBigDecimal).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.multiply(multiplicandBigDecimal).setScale(this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.multiply(multiplicandBigDecimal).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardMediumSoftBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return new HardMediumSoftBigDecimalScore((int)Math.floor((double)this.initScore / divisor), this.hardScore.divide(divisorBigDecimal, this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.divide(divisorBigDecimal, this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.divide(divisorBigDecimal, this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardMediumSoftBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return new HardMediumSoftBigDecimalScore((int)Math.floor(Math.pow(this.initScore, exponent)), this.hardScore.pow(exponentBigDecimal.intValue()).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.pow(exponentBigDecimal.intValue()).setScale(this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.pow(exponentBigDecimal.intValue()).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardMediumSoftBigDecimalScore negate() {
        return new HardMediumSoftBigDecimalScore(-this.initScore, this.hardScore.negate(), this.mediumScore.negate(), this.softScore.negate());
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardMediumSoftBigDecimalScore) {
            HardMediumSoftBigDecimalScore other = (HardMediumSoftBigDecimalScore)o;
            return this.initScore == other.getInitScore() && this.hardScore.stripTrailingZeros().equals(other.getHardScore().stripTrailingZeros()) && this.mediumScore.stripTrailingZeros().equals(other.getMediumScore().stripTrailingZeros()) && this.softScore.stripTrailingZeros().equals(other.getSoftScore().stripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore.stripTrailingZeros(), this.mediumScore.stripTrailingZeros(), this.softScore.stripTrailingZeros());
    }

    @Override
    public int compareTo(HardMediumSoftBigDecimalScore other) {
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        int hardScoreComparison = this.hardScore.compareTo(other.getHardScore());
        if (hardScoreComparison != 0) {
            return hardScoreComparison;
        }
        int mediumScoreComparison = this.mediumScore.compareTo(other.getMediumScore());
        if (mediumScoreComparison != 0) {
            return mediumScoreComparison;
        }
        return this.softScore.compareTo(other.getSoftScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + "hard/" + this.mediumScore + "medium/" + this.softScore + SOFT_LABEL;
    }
}

