/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoft;

import java.util.Objects;
import org.optaplanner.core.api.score.AbstractScore;

public final class HardSoftScore
extends AbstractScore<HardSoftScore> {
    public static final HardSoftScore ZERO = new HardSoftScore(0, 0, 0);
    public static final HardSoftScore ONE_HARD = new HardSoftScore(0, 1, 0);
    public static final HardSoftScore ONE_SOFT = new HardSoftScore(0, 0, 1);
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final int hardScore;
    private final int softScore;

    public static HardSoftScore parseScore(String scoreString) {
        String[] scoreTokens = HardSoftScore.parseScoreTokens(HardSoftScore.class, scoreString, HARD_LABEL, SOFT_LABEL);
        int initScore = HardSoftScore.parseInitScore(HardSoftScore.class, scoreString, scoreTokens[0]);
        int hardScore = HardSoftScore.parseLevelAsInt(HardSoftScore.class, scoreString, scoreTokens[1]);
        int softScore = HardSoftScore.parseLevelAsInt(HardSoftScore.class, scoreString, scoreTokens[2]);
        return HardSoftScore.ofUninitialized(initScore, hardScore, softScore);
    }

    public static HardSoftScore ofUninitialized(int initScore, int hardScore, int softScore) {
        return new HardSoftScore(initScore, hardScore, softScore);
    }

    public static HardSoftScore of(int hardScore, int softScore) {
        return new HardSoftScore(0, hardScore, softScore);
    }

    public static HardSoftScore ofHard(int hardScore) {
        return new HardSoftScore(0, hardScore, 0);
    }

    public static HardSoftScore ofSoft(int softScore) {
        return new HardSoftScore(0, 0, softScore);
    }

    private HardSoftScore() {
        super(Integer.MIN_VALUE);
        this.hardScore = Integer.MIN_VALUE;
        this.softScore = Integer.MIN_VALUE;
    }

    private HardSoftScore(int initScore, int hardScore, int softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardSoftScore withInitScore(int newInitScore) {
        return new HardSoftScore(newInitScore, this.hardScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0;
    }

    @Override
    public HardSoftScore add(HardSoftScore addend) {
        return new HardSoftScore(this.initScore + addend.getInitScore(), this.hardScore + addend.getHardScore(), this.softScore + addend.getSoftScore());
    }

    @Override
    public HardSoftScore subtract(HardSoftScore subtrahend) {
        return new HardSoftScore(this.initScore - subtrahend.getInitScore(), this.hardScore - subtrahend.getHardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardSoftScore multiply(double multiplicand) {
        return new HardSoftScore((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardSoftScore divide(double divisor) {
        return new HardSoftScore((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardSoftScore power(double exponent) {
        return new HardSoftScore((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.hardScore, exponent)), (int)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardSoftScore negate() {
        return new HardSoftScore(-this.initScore, -this.hardScore, -this.softScore);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftScore) {
            HardSoftScore other = (HardSoftScore)o;
            return this.initScore == other.getInitScore() && this.hardScore == other.getHardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore, this.softScore);
    }

    @Override
    public int compareTo(HardSoftScore other) {
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        if (this.hardScore != other.getHardScore()) {
            return Integer.compare(this.hardScore, other.getHardScore());
        }
        return Integer.compare(this.softScore, other.getSoftScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> n.intValue() != 0, HARD_LABEL, SOFT_LABEL);
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + "hard/" + this.softScore + SOFT_LABEL;
    }
}

