/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.LambdaBeanPropertyMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.ReflectionBeanPropertyMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.ReflectionFieldMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.ReflectionMethodMemberAccessor;

public class MemberAccessorFactory {
    static final String CLASSLOADER_NUDGE_MESSAGE = "Maybe add getClass().getClassLoader() as a parameter to the " + SolverFactory.class.getSimpleName() + ".create...() method call.";

    public static MemberAccessor buildMemberAccessor(Member member, MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return new ReflectionFieldMemberAccessor(field);
        }
        if (member instanceof Method) {
            MemberAccessor memberAccessor;
            Method method = (Method)member;
            switch (memberAccessorType) {
                case FIELD_OR_READ_METHOD: {
                    if (!ReflectionHelper.isGetterMethod(method)) {
                        ReflectionHelper.assertReadMethod(method, annotationClass);
                        memberAccessor = new ReflectionMethodMemberAccessor(method);
                        break;
                    }
                }
                case FIELD_OR_GETTER_METHOD: 
                case FIELD_OR_GETTER_METHOD_WITH_SETTER: {
                    boolean getterOnly = memberAccessorType != MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER;
                    ReflectionHelper.assertGetterMethod(method, annotationClass);
                    if (Modifier.isPublic(method.getModifiers()) && method.getDeclaringClass().getClassLoader().equals(MemberAccessor.class.getClassLoader())) {
                        memberAccessor = new LambdaBeanPropertyMemberAccessor(method, getterOnly);
                        break;
                    }
                    memberAccessor = new ReflectionBeanPropertyMemberAccessor(method, getterOnly);
                    break;
                }
                default: {
                    throw new IllegalStateException("The memberAccessorType (" + memberAccessorType + ") is not implemented.");
                }
            }
            if (memberAccessorType == MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER && !memberAccessor.supportSetter()) {
                throw new IllegalStateException("The class (" + method.getDeclaringClass() + ") has a " + annotationClass.getSimpleName() + " annotated getter method (" + method + "), but lacks a setter for that property (" + memberAccessor.getName() + ").");
            }
            return memberAccessor;
        }
        throw new IllegalStateException("Impossible state: the member (" + member + ")'s type is not a " + Field.class.getSimpleName() + " or a " + Method.class.getSimpleName() + ".");
    }

    private MemberAccessorFactory() {
    }

    public static enum MemberAccessorType {
        FIELD_OR_READ_METHOD,
        FIELD_OR_GETTER_METHOD,
        FIELD_OR_GETTER_METHOD_WITH_SETTER;

    }
}

