/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.lookup;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.optaplanner.core.api.domain.lookup.LookUpStrategyType;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.lookup.EqualsLookUpStrategy;
import org.optaplanner.core.impl.domain.lookup.ImmutableLookUpStrategy;
import org.optaplanner.core.impl.domain.lookup.LookUpStrategy;
import org.optaplanner.core.impl.domain.lookup.NoneLookUpStrategy;
import org.optaplanner.core.impl.domain.lookup.PlanningIdLookUpStrategy;

public class LookUpStrategyResolver {
    private final LookUpStrategyType lookUpStrategyType;
    private final ConcurrentMap<Class<?>, LookUpStrategy> decisionCache = new ConcurrentHashMap();

    public LookUpStrategyResolver(LookUpStrategyType lookUpStrategyType) {
        this.lookUpStrategyType = lookUpStrategyType;
        this.decisionCache.put(Boolean.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Byte.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Short.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Integer.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Long.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Float.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Double.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(BigInteger.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(BigDecimal.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Character.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(String.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Instant.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(LocalDateTime.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(LocalTime.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(LocalDate.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(MonthDay.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(YearMonth.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Year.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(OffsetDateTime.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(OffsetTime.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(ZonedDateTime.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(ZoneOffset.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Duration.class, new ImmutableLookUpStrategy());
        this.decisionCache.put(Period.class, new ImmutableLookUpStrategy());
    }

    public LookUpStrategy determineLookUpStrategy(Object object) {
        Class<?> objectClass = object.getClass();
        return this.decisionCache.computeIfAbsent(objectClass, key -> {
            if (object.getClass().isEnum()) {
                return new ImmutableLookUpStrategy();
            }
            switch (this.lookUpStrategyType) {
                case PLANNING_ID_OR_NONE: {
                    MemberAccessor memberAccessor1 = ConfigUtils.findPlanningIdMemberAccessor(objectClass);
                    if (memberAccessor1 == null) {
                        return new NoneLookUpStrategy();
                    }
                    return new PlanningIdLookUpStrategy(memberAccessor1);
                }
                case PLANNING_ID_OR_FAIL_FAST: {
                    MemberAccessor memberAccessor2 = ConfigUtils.findPlanningIdMemberAccessor(objectClass);
                    if (memberAccessor2 == null) {
                        throw new IllegalArgumentException("The class (" + objectClass + ") does not have a " + PlanningId.class.getSimpleName() + " annotation, but the lookUpStrategyType (" + this.lookUpStrategyType + ") requires it.\nMaybe add the " + PlanningId.class.getSimpleName() + " annotation or change the " + PlanningSolution.class.getSimpleName() + " annotation's " + LookUpStrategyType.class.getSimpleName() + ".");
                    }
                    return new PlanningIdLookUpStrategy(memberAccessor2);
                }
                case EQUALITY: {
                    Method hashCodeMethod;
                    Method equalsMethod;
                    try {
                        equalsMethod = object.getClass().getMethod("equals", Object.class);
                        hashCodeMethod = object.getClass().getMethod("hashCode", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException("Impossible state because equals() and hashCode() always exist.", e);
                    }
                    if (equalsMethod.getDeclaringClass().equals(Object.class)) {
                        throw new IllegalArgumentException("The class (" + object.getClass().getSimpleName() + ") doesn't override the equals() method, neither does any superclass.");
                    }
                    if (hashCodeMethod.getDeclaringClass().equals(Object.class)) {
                        throw new IllegalArgumentException("The class (" + object.getClass().getSimpleName() + ") overrides equals() but neither it nor any superclass overrides the hashCode() method.");
                    }
                    return new EqualsLookUpStrategy();
                }
                case NONE: {
                    return new NoneLookUpStrategy();
                }
            }
            throw new IllegalStateException("The lookUpStrategyType (" + this.lookUpStrategyType + ") is not implemented.");
        });
    }
}

