/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.lang3.ArrayUtils;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.valuerange.descriptor.CompositeValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.FromEntityPropertyValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.FromSolutionPropertyValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.NullValueReinitializeVariableEntityFilter;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.MovableChainedTrailingValueFilter;

public class GenuineVariableDescriptor<Solution_>
extends VariableDescriptor<Solution_> {
    private boolean chained;
    private ValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private boolean nullable;
    private SelectionFilter<Solution_, Object> movableChainedTrailingValueFilter;
    private SelectionFilter<Solution_, Object> reinitializeVariableEntityFilter;
    private SelectionSorter<Solution_, Object> increasingStrengthSorter;
    private SelectionSorter<Solution_, Object> decreasingStrengthSorter;

    public GenuineVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningVariable planningVariableAnnotation = this.variableMemberAccessor.getAnnotation(PlanningVariable.class);
        this.processNullable(descriptorPolicy, planningVariableAnnotation);
        this.processChained(descriptorPolicy, planningVariableAnnotation);
        this.processValueRangeRefs(descriptorPolicy, planningVariableAnnotation);
        this.processStrength(descriptorPolicy, planningVariableAnnotation);
    }

    private void processNullable(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        this.nullable = planningVariableAnnotation.nullable();
        if (this.nullable && this.variableMemberAccessor.getType().isPrimitive()) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variableMemberAccessor.getName() + ") with nullable (" + this.nullable + "), which is not compatible with the primitive propertyType (" + this.variableMemberAccessor.getType() + ").");
        }
        this.reinitializeVariableEntityFilter = new NullValueReinitializeVariableEntityFilter(this);
    }

    private void processChained(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        boolean bl = this.chained = planningVariableAnnotation.graphType() == PlanningVariableGraphType.CHAINED;
        if (this.chained && !this.variableMemberAccessor.getType().isAssignableFrom(this.entityDescriptor.getEntityClass())) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variableMemberAccessor.getName() + ") with chained (" + this.chained + ") and propertyType (" + this.variableMemberAccessor.getType() + ") which is not a superclass/interface of or the same as the entityClass (" + this.entityDescriptor.getEntityClass() + ").\nIf an entity's chained planning variable cannot point to another entity of the same class, then it is impossible to make chain longer than 1 entity and therefore chaining is useless.");
        }
        if (this.chained && this.nullable) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variableMemberAccessor.getName() + ") with chained (" + this.chained + "), which is not compatible with nullable (" + this.nullable + ").");
        }
    }

    private void processValueRangeRefs(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Object[] valueRangeProviderRefs = planningVariableAnnotation.valueRangeProviderRefs();
        if (ArrayUtils.isEmpty((Object[])valueRangeProviderRefs)) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") that has no valueRangeProviderRefs (" + Arrays.toString(valueRangeProviderRefs) + ").");
        }
        ArrayList valueRangeDescriptorList = new ArrayList(valueRangeProviderRefs.length);
        boolean addNullInValueRange = this.nullable && valueRangeProviderRefs.length == 1;
        for (Object valueRangeProviderRef : valueRangeProviderRefs) {
            valueRangeDescriptorList.add(this.buildValueRangeDescriptor(descriptorPolicy, (String)valueRangeProviderRef, addNullInValueRange));
        }
        this.valueRangeDescriptor = valueRangeDescriptorList.size() == 1 ? (ValueRangeDescriptor)valueRangeDescriptorList.get(0) : new CompositeValueRangeDescriptor(this, this.nullable, valueRangeDescriptorList);
    }

    private ValueRangeDescriptor<Solution_> buildValueRangeDescriptor(DescriptorPolicy descriptorPolicy, String valueRangeProviderRef, boolean addNullInValueRange) {
        if (descriptorPolicy.hasFromSolutionValueRangeProvider(valueRangeProviderRef)) {
            MemberAccessor memberAccessor = descriptorPolicy.getFromSolutionValueRangeProvider(valueRangeProviderRef);
            return new FromSolutionPropertyValueRangeDescriptor(this, addNullInValueRange, memberAccessor);
        }
        if (descriptorPolicy.hasFromEntityValueRangeProvider(valueRangeProviderRef)) {
            MemberAccessor memberAccessor = descriptorPolicy.getFromEntityValueRangeProvider(valueRangeProviderRef);
            return new FromEntityPropertyValueRangeDescriptor(this, addNullInValueRange, memberAccessor);
        }
        Collection<String> providerIds = descriptorPolicy.getValueRangeProviderIds();
        throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " property (" + this.variableMemberAccessor.getName() + ") with a valueRangeProviderRef (" + valueRangeProviderRef + ") that does not exist in a @" + ValueRangeProvider.class.getSimpleName() + " on the solution class (" + this.entityDescriptor.getSolutionDescriptor().getSolutionClass().getSimpleName() + ") or on that entityClass.\nThe valueRangeProviderRef (" + valueRangeProviderRef + ") does not appear in the valueRangeProvideIds (" + providerIds + ")." + (String)(!providerIds.isEmpty() ? "" : "\nMaybe a @" + ValueRangeProvider.class.getSimpleName() + " annotation is missing on a method in the solution class (" + this.entityDescriptor.getSolutionDescriptor().getSolutionClass().getSimpleName() + ")."));
    }

    private void processStrength(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Class<? extends SelectionSorterWeightFactory> strengthWeightFactoryClass;
        Class<? extends Comparator> strengthComparatorClass = planningVariableAnnotation.strengthComparatorClass();
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if ((strengthWeightFactoryClass = planningVariableAnnotation.strengthWeightFactoryClass()) == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") property (" + this.variableMemberAccessor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        if (strengthComparatorClass != null) {
            Comparator strengthComparator = ConfigUtils.newInstance(this, "strengthComparatorClass", strengthComparatorClass);
            this.increasingStrengthSorter = new ComparatorSelectionSorter<Solution_, Object>(strengthComparator, SelectionSorterOrder.ASCENDING);
            this.decreasingStrengthSorter = new ComparatorSelectionSorter<Solution_, Object>(strengthComparator, SelectionSorterOrder.DESCENDING);
        }
        if (strengthWeightFactoryClass != null) {
            SelectionSorterWeightFactory strengthWeightFactory = ConfigUtils.newInstance(this, "strengthWeightFactoryClass", strengthWeightFactoryClass);
            this.increasingStrengthSorter = new WeightFactorySelectionSorter<Solution_, Object>(strengthWeightFactory, SelectionSorterOrder.ASCENDING);
            this.decreasingStrengthSorter = new WeightFactorySelectionSorter<Solution_, Object>(strengthWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.movableChainedTrailingValueFilter = this.chained && this.entityDescriptor.hasEffectiveMovableEntitySelectionFilter() ? new MovableChainedTrailingValueFilter(this) : null;
    }

    public boolean isChained() {
        return this.chained;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean hasMovableChainedTrailingValueFilter() {
        return this.movableChainedTrailingValueFilter != null;
    }

    public SelectionFilter<Solution_, Object> getMovableChainedTrailingValueFilter() {
        return this.movableChainedTrailingValueFilter;
    }

    public SelectionFilter<Solution_, Object> getReinitializeVariableEntityFilter() {
        return this.reinitializeVariableEntityFilter;
    }

    public ValueRangeDescriptor<Solution_> getValueRangeDescriptor() {
        return this.valueRangeDescriptor;
    }

    public boolean isValueRangeEntityIndependent() {
        return this.valueRangeDescriptor.isEntityIndependent();
    }

    public boolean isInitialized(Object entity) {
        if (this.nullable) {
            return true;
        }
        Object variable = this.getValue(entity);
        return variable != null;
    }

    @Override
    public boolean isGenuineAndUninitialized(Object entity) {
        return !this.isInitialized(entity);
    }

    public boolean isReinitializable(ScoreDirector<Solution_> scoreDirector, Object entity) {
        return this.reinitializeVariableEntityFilter.accept(scoreDirector, entity);
    }

    public SelectionSorter<Solution_, Object> getIncreasingStrengthSorter() {
        return this.increasingStrengthSorter;
    }

    public SelectionSorter<Solution_, Object> getDecreasingStrengthSorter() {
        return this.decreasingStrengthSorter;
    }

    public long getValueCount(Solution_ solution, Object entity) {
        if (!this.valueRangeDescriptor.isCountable()) {
            return 0L;
        }
        return ((CountableValueRange)this.valueRangeDescriptor.extractValueRange(solution, entity)).getSize();
    }

    public String toString() {
        return this.getSimpleEntityAndVariableName() + " variable";
    }
}

