/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common;

import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class SelectionCacheLifecycleBridge<Solution_>
implements PhaseLifecycleListener<Solution_> {
    protected final SelectionCacheType cacheType;
    protected final SelectionCacheLifecycleListener<Solution_> selectionCacheLifecycleListener;

    public SelectionCacheLifecycleBridge(SelectionCacheType cacheType, SelectionCacheLifecycleListener<Solution_> selectionCacheLifecycleListener) {
        this.cacheType = cacheType;
        this.selectionCacheLifecycleListener = selectionCacheLifecycleListener;
        if (cacheType == null) {
            throw new IllegalArgumentException("The cacheType (" + cacheType + ") for selectionCacheLifecycleListener (" + selectionCacheLifecycleListener + ") should have already been resolved.");
        }
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        if (this.cacheType == SelectionCacheType.SOLVER) {
            this.selectionCacheLifecycleListener.constructCache(solverScope);
        }
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        if (this.cacheType == SelectionCacheType.PHASE) {
            this.selectionCacheLifecycleListener.constructCache(phaseScope.getSolverScope());
        }
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        if (this.cacheType == SelectionCacheType.STEP) {
            this.selectionCacheLifecycleListener.constructCache(stepScope.getPhaseScope().getSolverScope());
        }
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        if (this.cacheType == SelectionCacheType.STEP) {
            this.selectionCacheLifecycleListener.disposeCache(stepScope.getPhaseScope().getSolverScope());
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        if (this.cacheType == SelectionCacheType.PHASE) {
            this.selectionCacheLifecycleListener.disposeCache(phaseScope.getSolverScope());
        }
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        if (this.cacheType == SelectionCacheType.SOLVER) {
            this.selectionCacheLifecycleListener.disposeCache(solverScope);
        }
    }

    public String toString() {
        return "Bridge(" + this.selectionCacheLifecycleListener + ")";
    }
}

