/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Global;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintWeightDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirector;

public class DroolsScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirectorFactory<Solution_, Score_> {
    private final KieBase kieBase;
    protected Map<Rule, Function<Solution_, Score_>> ruleToConstraintWeightExtractorMap;

    public DroolsScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, KieBase kieBase) {
        super(solutionDescriptor);
        this.kieBase = kieBase;
        this.checkIfGlobalScoreHolderExists(kieBase);
        this.createRuleToConstraintWeightExtractorMap(kieBase);
        solutionDescriptor.checkIfProblemFactsExist();
    }

    protected void checkIfGlobalScoreHolderExists(KieBase kieBase) {
        boolean hasGlobalScoreHolder = false;
        block0: for (KiePackage kiePackage : kieBase.getKiePackages()) {
            for (Global global : kiePackage.getGlobalVariables()) {
                if (!"scoreHolder".equals(global.getName())) continue;
                hasGlobalScoreHolder = true;
                continue block0;
            }
        }
        if (!hasGlobalScoreHolder) {
            throw new IllegalArgumentException("The kieBase with kiePackages (" + kieBase.getKiePackages() + ") has no global field called scoreHolder.\nCheck if the rule files are found and if the global field is spelled correctly.");
        }
    }

    protected void createRuleToConstraintWeightExtractorMap(KieBase kieBase) {
        ConstraintConfigurationDescriptor constraintConfigurationDescriptor = this.solutionDescriptor.getConstraintConfigurationDescriptor();
        if (constraintConfigurationDescriptor == null) {
            this.ruleToConstraintWeightExtractorMap = new LinkedHashMap<Rule, Function<Solution_, Score_>>(0);
            return;
        }
        Collection constraintWeightDescriptors = constraintConfigurationDescriptor.getConstraintWeightDescriptors();
        this.ruleToConstraintWeightExtractorMap = new LinkedHashMap<Rule, Function<Solution_, Score_>>(constraintWeightDescriptors.size());
        for (ConstraintWeightDescriptor constraintWeightDescriptor : constraintWeightDescriptors) {
            String constraintName;
            String constraintPackage = constraintWeightDescriptor.getConstraintPackage();
            Rule rule = kieBase.getRule(constraintPackage, constraintName = constraintWeightDescriptor.getConstraintName());
            if (rule == null) {
                Rule potentialRule = kieBase.getKiePackages().stream().flatMap(kiePackage -> kiePackage.getRules().stream()).filter(selectedRule -> selectedRule.getName().equals(constraintName)).findFirst().orElse(null);
                throw new IllegalStateException("The constraintConfigurationClass (" + constraintConfigurationDescriptor.getConstraintConfigurationClass() + ") has a " + ConstraintWeight.class.getSimpleName() + " annotated member (" + constraintWeightDescriptor.getMemberAccessor() + ") with constraintPackage/rulePackage (" + constraintPackage + ") and constraintName/ruleName (" + constraintName + ") for which no Drools rule exist in the DRL.\n" + (potentialRule != null ? "Maybe the constraintPackage (" + constraintPackage + ") is wrong, because there is a rule with the same ruleName (" + constraintName + "), but in a different rulePackage (" + potentialRule.getPackageName() + ")." : "Maybe there is a typo in the constraintName (" + constraintName + ") so it not identical to the constraint's ruleName."));
            }
            Function constraintWeightExtractor = constraintWeightDescriptor.createExtractor();
            this.ruleToConstraintWeightExtractorMap.put(rule, constraintWeightExtractor);
        }
    }

    public Map<Rule, Function<Solution_, Score_>> getRuleToConstraintWeightExtractorMap() {
        return this.ruleToConstraintWeightExtractorMap;
    }

    @Override
    public DroolsScoreDirector<Solution_, Score_> buildScoreDirector(boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        return new DroolsScoreDirector(this, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public KieSession newKieSession() {
        return this.kieBase.newKieSession();
    }
}

