/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.stream;

import java.util.Arrays;
import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirector;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;

public class ConstraintStreamScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirectorFactory<Solution_, Score_> {
    private final ConstraintSessionFactory<Solution_, Score_> constraintSessionFactory;
    private final Constraint[] constraints;

    public ConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, ConstraintStreamImplType constraintStreamImplType) {
        super(solutionDescriptor);
        InnerConstraintFactory constraintFactory;
        switch (constraintStreamImplType) {
            case BAVET: {
                constraintFactory = new BavetConstraintFactory<Solution_>(solutionDescriptor);
                break;
            }
            case DROOLS: {
                constraintFactory = new DroolsConstraintFactory<Solution_>(solutionDescriptor);
                break;
            }
            default: {
                throw new IllegalStateException("The constraintStreamImplType (" + constraintStreamImplType + ") is not implemented.");
            }
        }
        this.constraints = constraintProvider.defineConstraints(constraintFactory);
        if (this.constraints == null) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not return null.\nMaybe return an empty array instead if there are no constraints.");
        }
        if (Arrays.stream(this.constraints).anyMatch(Objects::isNull)) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not contain an element that is null.\nMaybe don't include any null elements in the " + Constraint.class.getSimpleName() + " array.");
        }
        this.constraintSessionFactory = constraintFactory.buildSessionFactory(this.constraints);
    }

    @Override
    public ConstraintStreamScoreDirector<Solution_, Score_> buildScoreDirector(boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        return new ConstraintStreamScoreDirector(this, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public ConstraintSession<Solution_, Score_> newConstraintStreamingSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        return this.constraintSessionFactory.buildSession(constraintMatchEnabled, workingSolution);
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }
}

