/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.holder;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drools.core.common.AgendaItem;
import org.drools.core.spi.Activation;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.constraint.DefaultConstraintMatchTotal;
import org.optaplanner.core.impl.score.constraint.DefaultIndictment;

public abstract class AbstractScoreHolder<Score_ extends Score<Score_>>
implements ScoreHolder<Score_> {
    protected final boolean constraintMatchEnabled;
    protected final Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap;
    protected final Map<Object, Indictment<Score_>> indictmentMap;
    protected final Score_ zeroScore;
    private BiFunction<List<Object>, Rule, List<Object>> justificationListConverter = null;

    protected AbstractScoreHolder(boolean constraintMatchEnabled, Score_ zeroScore) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.constraintMatchTotalMap = constraintMatchEnabled ? new LinkedHashMap() : null;
        this.indictmentMap = constraintMatchEnabled ? new LinkedHashMap() : null;
        this.zeroScore = zeroScore;
    }

    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabled;
    }

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.constraintMatchTotalMap;
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.indictmentMap;
    }

    public void configureConstraintWeight(Rule rule, Score_ constraintWeight) {
        if (constraintWeight.getInitScore() != 0) {
            throw new IllegalStateException("The initScore (" + constraintWeight.getInitScore() + ") must be 0.");
        }
        if (this.constraintMatchEnabled) {
            String constraintPackage = rule.getPackageName();
            String constraintName = rule.getName();
            String constraintId = ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName);
            this.constraintMatchTotalMap.put(constraintId, new DefaultConstraintMatchTotal<Score_>(constraintPackage, constraintName, constraintWeight, this.zeroScore));
        }
    }

    protected void registerConstraintMatch(RuleContext kcontext, Runnable constraintUndoListener, Supplier<Score_> scoreSupplier) {
        AgendaItem agendaItem = (AgendaItem)kcontext.getMatch();
        ConstraintActivationUnMatchListener constraintActivationUnMatchListener = new ConstraintActivationUnMatchListener(constraintUndoListener);
        agendaItem.setCallback((Runnable)constraintActivationUnMatchListener);
        if (this.constraintMatchEnabled) {
            List<Object> justificationList = this.extractJustificationList(kcontext);
            constraintActivationUnMatchListener.constraintMatchTotal = this.findConstraintMatchTotal(kcontext);
            ConstraintMatch<Score> constraintMatch = constraintActivationUnMatchListener.constraintMatchTotal.addConstraintMatch(justificationList, (Score)scoreSupplier.get());
            List indictmentList = justificationList.stream().distinct().map(justification -> {
                DefaultIndictment indictment = (DefaultIndictment)this.indictmentMap.computeIfAbsent(justification, k -> new DefaultIndictment<Score_>(justification, this.zeroScore));
                indictment.addConstraintMatch(constraintMatch);
                return indictment;
            }).collect(Collectors.toList());
            constraintActivationUnMatchListener.constraintMatch = constraintMatch;
            constraintActivationUnMatchListener.indictmentList = indictmentList;
        }
    }

    private DefaultConstraintMatchTotal<Score_> findConstraintMatchTotal(RuleContext kcontext) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        String constraintId = ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName);
        return (DefaultConstraintMatchTotal)this.constraintMatchTotalMap.computeIfAbsent(constraintId, k -> new DefaultConstraintMatchTotal<Object>(constraintPackage, constraintName, null, this.zeroScore));
    }

    public void impactScore(RuleContext kcontext) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") requires a weightMultiplier.");
    }

    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support an int weightMultiplier (" + weightMultiplier + ").");
    }

    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support an int weightMultiplier (" + weightMultiplier + ").");
    }

    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support an int weightMultiplier (" + weightMultiplier + ").");
    }

    public abstract Score_ extractScore(int var1);

    protected List<Object> extractJustificationList(RuleContext kcontext) {
        Activation activation = (Activation)kcontext.getMatch();
        List objects = activation.getObjectsDeep();
        if (this.justificationListConverter == null) {
            return objects;
        }
        return this.justificationListConverter.apply(objects, kcontext.getRule());
    }

    public void setJustificationListConverter(BiFunction<List<Object>, Rule, List<Object>> converter) {
        this.justificationListConverter = converter;
    }

    public class ConstraintActivationUnMatchListener
    implements Runnable {
        private final Runnable constraintUndoListener;
        private DefaultConstraintMatchTotal<Score_> constraintMatchTotal;
        private List<DefaultIndictment<Score_>> indictmentList;
        private ConstraintMatch<Score_> constraintMatch;

        public ConstraintActivationUnMatchListener(Runnable constraintUndoListener) {
            this.constraintUndoListener = constraintUndoListener;
        }

        @Override
        public final void run() {
            this.constraintUndoListener.run();
            if (AbstractScoreHolder.this.constraintMatchEnabled) {
                this.constraintMatchTotal.removeConstraintMatch(this.constraintMatch);
                for (DefaultIndictment indictment : this.indictmentList) {
                    indictment.removeConstraintMatch(this.constraintMatch);
                    if (!indictment.getConstraintMatchSet().isEmpty()) continue;
                    AbstractScoreHolder.this.indictmentMap.remove(indictment.getJustification());
                }
            }
        }
    }
}

