/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.model.Model;
import org.drools.model.Rule;
import org.drools.model.impl.ModelImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.OptaPlannerRuleEventListener;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSession;
import org.optaplanner.core.impl.score.stream.drools.common.FactTuple;

public final class DroolsConstraintSessionFactory<Solution_, Score_ extends Score<Score_>>
implements ConstraintSessionFactory<Solution_, Score_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Model originalModel;
    private final KieBase originalKieBase;
    private final Map<org.kie.api.definition.rule.Rule, DroolsConstraint<Solution_>> compiledRuleToConstraintMap;
    private final Map<String, Rule> constraintToModelRuleMap;
    private final Map<org.kie.api.definition.rule.Rule, Class[]> compiledRuleToExpectedTypesMap;
    private KieBase currentKieBase;
    private Set<String> currentlyDisabledConstraintIdSet = null;

    public DroolsConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, Model model, Map<Rule, Class[]> modelRuleToExpectedTypesMap, DroolsConstraint<Solution_> ... constraints) {
        this.solutionDescriptor = solutionDescriptor;
        this.originalModel = model;
        this.currentKieBase = this.originalKieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseOption[])new KieBaseOption[0]);
        this.compiledRuleToConstraintMap = Arrays.stream(constraints).collect(Collectors.toMap(constraint -> this.currentKieBase.getRule(constraint.getConstraintPackage(), constraint.getConstraintName()), Function.identity()));
        this.constraintToModelRuleMap = Arrays.stream(constraints).collect(Collectors.toMap(Constraint::getConstraintId, constraint -> model.getRules().stream().filter(rule -> Objects.equals(rule.getName(), constraint.getConstraintName())).filter(rule -> Objects.equals(rule.getPackage(), constraint.getConstraintPackage())).findFirst().orElseThrow(() -> new IllegalStateException("Impossible state: Rule for constraint (" + constraint + ") not found."))));
        this.compiledRuleToExpectedTypesMap = this.compiledRuleToConstraintMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            DroolsConstraint constraint = (DroolsConstraint)e.getValue();
            Rule modelRule = this.constraintToModelRuleMap.get(constraint.getConstraintId());
            return (Class[])modelRuleToExpectedTypesMap.get(modelRule);
        }));
    }

    private static List<Object> matchJustificationsToOutput(List<Object> justificationList, int expectedCount, Class ... expectedTypes) {
        Class expectedType;
        int i;
        if (expectedTypes.length == 0) {
            throw new IllegalStateException("Impossible: there are no 0-cardinality constraint streams.");
        }
        Object[] matching = new Object[expectedTypes.length];
        for (i = 0; i < expectedTypes.length; ++i) {
            expectedType = expectedTypes[i];
            if (Objects.equals(expectedType, Object.class)) continue;
            Object match = justificationList.stream().filter(j -> expectedType.isAssignableFrom(j.getClass())).findFirst().orElseThrow(() -> new IllegalStateException("Impossible: no justification of type (" + expectedType + ")."));
            justificationList.remove(match);
            matching[i] = match;
        }
        for (i = 0; i < expectedTypes.length; ++i) {
            if (matching[i] != null) continue;
            Object match = justificationList.stream().findFirst().orElseThrow(() -> new IllegalStateException("Impossible: there are no more constraint matches."));
            justificationList.remove(match);
            matching[i] = match;
        }
        if (matching.length > 1) {
            return Arrays.asList(matching);
        }
        Object item = matching[0];
        expectedType = expectedTypes[0];
        if (FactTuple.class.isAssignableFrom(expectedType) || item instanceof FactTuple) {
            return ((FactTuple)item).asList().subList(0, expectedCount);
        }
        return Collections.singletonList(item);
    }

    @Override
    public ConstraintSession<Solution_, Score_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        AbstractScoreHolder scoreHolder = scoreDefinition.buildScoreHolder(constraintMatchEnabled);
        scoreHolder.setJustificationListConverter((justificationList, rule) -> {
            DroolsConstraint<Solution_> constraint = this.compiledRuleToConstraintMap.get(rule);
            Class[] expectedTypes = this.compiledRuleToExpectedTypesMap.get(rule);
            return DroolsConstraintSessionFactory.matchJustificationsToOutput(justificationList, constraint.getConsequence().getTerminalNode().getCardinality(), expectedTypes);
        });
        Object zeroScore = scoreDefinition.getZeroScore();
        LinkedHashSet<String> disabledConstraintIdSet = new LinkedHashSet<String>(0);
        this.compiledRuleToConstraintMap.forEach((compiledRule, constraint) -> {
            Score<?> constraintWeight = constraint.extractConstraintWeight(workingSolution);
            scoreHolder.configureConstraintWeight((org.kie.api.definition.rule.Rule)compiledRule, constraintWeight);
            if (constraintWeight.equals(zeroScore)) {
                disabledConstraintIdSet.add(constraint.getConstraintId());
            }
        });
        if (disabledConstraintIdSet.isEmpty()) {
            this.currentKieBase = this.originalKieBase;
            this.currentlyDisabledConstraintIdSet = null;
        } else if (!disabledConstraintIdSet.equals(this.currentlyDisabledConstraintIdSet)) {
            ModelImpl model = new ModelImpl().withGlobals(this.originalModel.getGlobals());
            this.constraintToModelRuleMap.forEach((constraintId, modelRule) -> {
                if (disabledConstraintIdSet.contains(constraintId)) {
                    return;
                }
                model.addRule(modelRule);
            });
            this.currentKieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseOption[])new KieBaseOption[0]);
            this.currentlyDisabledConstraintIdSet = disabledConstraintIdSet;
        }
        KieSession kieSession = this.currentKieBase.newKieSession();
        ((RuleEventManager)kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        kieSession.setGlobal("scoreHolder", scoreHolder);
        return new DroolsConstraintSession(this.solutionDescriptor, kieSession, scoreHolder);
    }
}

