/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNodeType;
import org.optaplanner.core.impl.score.stream.drools.common.rules.RuleAssembler;

final class ConstraintSubTree {
    private final DroolsVariableFactory variableFactory;
    private final boolean isJoin;
    private final ConstraintSubTree leftSubTree;
    private final ConstraintSubTree rightSubTree;
    private final List<ConstraintGraphNode> nodeList;

    public ConstraintSubTree(List<ConstraintGraphNode> joinlessNodeList, DroolsVariableFactory variableFactory) {
        this.variableFactory = variableFactory;
        this.isJoin = false;
        this.leftSubTree = null;
        this.rightSubTree = null;
        this.nodeList = Collections.unmodifiableList(joinlessNodeList);
        if (this.nodeList.isEmpty()) {
            throw new IllegalStateException("Impossible state: Node list is empty.");
        }
        ConstraintGraphNode firstNode = this.nodeList.get(0);
        ConstraintGraphNodeType firstNodeType = firstNode.getType();
        if (firstNodeType != ConstraintGraphNodeType.FROM) {
            throw new IllegalStateException("Impossible state: First node (" + firstNode + ") is not " + ConstraintGraphNodeType.FROM + " (" + firstNodeType + ").");
        }
    }

    public ConstraintSubTree(ConstraintSubTree leftSubTree, ConstraintSubTree rightSubTree, List<ConstraintGraphNode> joinAndOtherNodesList, DroolsVariableFactory variableFactory) {
        this.variableFactory = variableFactory;
        this.isJoin = true;
        this.leftSubTree = Objects.requireNonNull(leftSubTree);
        this.rightSubTree = Objects.requireNonNull(rightSubTree);
        this.nodeList = Collections.unmodifiableList(joinAndOtherNodesList);
        if (this.nodeList.isEmpty()) {
            throw new IllegalStateException("Impossible state: Node list is empty.");
        }
        ConstraintGraphNode firstNode = this.nodeList.get(0);
        ConstraintGraphNodeType firstNodeType = firstNode.getType();
        if (this.nodeList.get(0).getType() != ConstraintGraphNodeType.JOIN) {
            throw new IllegalStateException("Impossible state: First node (" + firstNode + ") is not " + ConstraintGraphNodeType.JOIN + " (" + firstNodeType + ").");
        }
    }

    public int getGroupByCount() {
        long groupByCount = this.nodeList.stream().filter(n -> n.getType() == ConstraintGraphNodeType.GROUPBY_COLLECTING_ONLY || n.getType() == ConstraintGraphNodeType.GROUPBY_MAPPING_ONLY || n.getType() == ConstraintGraphNodeType.GROUPBY_MAPPING_AND_COLLECTING).count();
        if (this.isJoin) {
            groupByCount += (long)this.leftSubTree.getGroupByCount();
            groupByCount += (long)this.rightSubTree.getGroupByCount();
        }
        return (int)groupByCount;
    }

    public RuleAssembler getRuleAssembler() {
        RuleAssembler builder = this.isJoin ? this.leftSubTree.getRuleAssembler().join(this.rightSubTree.getRuleAssembler(), this.nodeList.get(0)) : RuleAssembler.from(this.variableFactory, this.nodeList.get(0), this.getGroupByCount());
        for (int i = 1; i < this.nodeList.size(); ++i) {
            builder = builder.andThen(this.nodeList.get(i));
        }
        return builder;
    }
}

