/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ChildNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNodeType;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.FromNode;

public abstract class AbstractConstraintModelChildNode
extends AbstractConstraintModelNode
implements ChildNode {
    private final List<ConstraintGraphNode> parentNodeList = new ArrayList<ConstraintGraphNode>(0);

    AbstractConstraintModelChildNode(ConstraintGraphNodeType type) {
        super(type);
    }

    public final void addParentNode(ConstraintGraphNode node) {
        ConstraintGraphNode nonNullNode = Objects.requireNonNull(node);
        if (this.parentNodeList.contains(nonNullNode)) {
            throw new IllegalStateException("Node (" + this + ") already has this parent node (" + nonNullNode + ").");
        }
        this.parentNodeList.add(nonNullNode);
    }

    public final Class getFactType() {
        if (this.parentNodeList.isEmpty()) {
            throw new IllegalStateException("Impossible state: Child node (" + this + ") has no parents.");
        }
        if (this.parentNodeList.size() == 1) {
            AbstractConstraintModelNode parentNode = (AbstractConstraintModelNode)this.parentNodeList.get(0);
            if (parentNode instanceof FromNode) {
                return ((FromNode)parentNode).getFactType();
            }
            if (parentNode instanceof AbstractConstraintModelChildNode) {
                return ((AbstractConstraintModelChildNode)parentNode).getFactType();
            }
            throw new IllegalStateException("Impossible state: Parent node (" + parentNode + ") without fact type accessor.");
        }
        return null;
    }

    @Override
    public final List<ConstraintGraphNode> getParentNodes() {
        return Collections.unmodifiableList(this.parentNodeList);
    }
}

