/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.drools.model.DSL;
import org.drools.model.DeclarationSource;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractAccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.FactTuple;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.Mutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniRuleAssembler;

abstract class AbstractGroupByMutator
implements Mutator {
    AbstractGroupByMutator() {
    }

    protected abstract <InTuple> PatternDSL.PatternDef bindTupleVariableOnFirstGrouping(AbstractRuleAssembler var1, PatternDSL.PatternDef var2, Variable<InTuple> var3);

    protected ViewItem getInnerAccumulatePattern(AbstractRuleAssembler<?> ruleAssembler) {
        ArrayList<ViewItem> patternList = new ArrayList<ViewItem>();
        for (int i = 0; i < ruleAssembler.getPrimaryPatterns().size(); ++i) {
            patternList.add((ViewItem)ruleAssembler.getPrimaryPatterns().get(i));
            patternList.addAll(ruleAssembler.getDependentExpressionMap().getOrDefault(i, Collections.emptyList()));
        }
        ViewItem firstPattern = (ViewItem)patternList.get(0);
        if (patternList.size() == 1) {
            return firstPattern;
        }
        ViewItem[] remainingPatternArray = patternList.subList(1, patternList.size()).toArray(new ViewItem[0]);
        return DSL.and((ViewItemBuilder)firstPattern, (ViewItemBuilder[])remainingPatternArray);
    }

    protected <NewA, InTuple, OutTuple> AbstractRuleAssembler collect(AbstractRuleAssembler ruleAssembler, DroolsAbstractAccumulateFunction<?, InTuple, OutTuple> accumulateFunctionBridge) {
        Variable tupleVariable;
        ruleAssembler.applyFilterToLastPrimaryPattern();
        PatternDSL.PatternDef mainAccumulatePattern = ruleAssembler.getLastPrimaryPattern();
        boolean isRegrouping = FactTuple.class.isAssignableFrom(mainAccumulatePattern.getFirstVariable().getType());
        Variable variable = tupleVariable = isRegrouping ? mainAccumulatePattern.getFirstVariable() : ruleAssembler.createVariable("tuple");
        if (!isRegrouping) {
            this.bindTupleVariableOnFirstGrouping(ruleAssembler, mainAccumulatePattern, tupleVariable);
        }
        ViewItem innerAccumulatePattern = this.getInnerAccumulatePattern(ruleAssembler);
        Variable outputVariable = ruleAssembler.createVariable("collected");
        ExprViewItem outerAccumulatePattern = DSL.accumulate((ViewItem)innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(() -> accumulateFunctionBridge, tupleVariable).as(outputVariable), (AccumulateFunction[])new AccumulateFunction[0]);
        return this.recollect(ruleAssembler, outputVariable, (ViewItem)outerAccumulatePattern);
    }

    protected <InTuple> AbstractRuleAssembler groupWithCollect(AbstractRuleAssembler ruleAssembler, Supplier<? extends DroolsAbstractGroupByAccumulator<InTuple>> invokerSupplier) {
        return this.universalGroupWithCollect(ruleAssembler, invokerSupplier, (var, pattern, accumulate) -> this.regroupBi(ruleAssembler, (Variable)var, (ViewItem)pattern, (ViewItem)accumulate));
    }

    private <InTuple> AbstractRuleAssembler universalGroupWithCollect(AbstractRuleAssembler ruleAssembler, Supplier<? extends DroolsAbstractGroupByAccumulator<InTuple>> invokerSupplier, Transformer<InTuple> mutator) {
        ruleAssembler.applyFilterToLastPrimaryPattern();
        ViewItem innerAccumulatePattern = this.getInnerAccumulatePattern(ruleAssembler);
        Variable<Collection> tupleCollection = ruleAssembler.createVariable(Collection.class, "tupleCollection");
        PatternDSL.PatternDef pattern = PatternDSL.pattern(tupleCollection).expr("Non-empty", (Predicate1 & Serializable)collection -> !collection.isEmpty(), PatternDSL.alphaIndexedBy(Integer.class, (Index.ConstraintType)Index.ConstraintType.GREATER_THAN, (int)-1, Collection::size, (Object)0));
        ExprViewItem accumulate = DSL.accumulate((ViewItem)innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(invokerSupplier).as(tupleCollection), (AccumulateFunction[])new AccumulateFunction[0]);
        return (AbstractRuleAssembler)mutator.apply(tupleCollection, pattern, accumulate);
    }

    protected <InTuple> AbstractRuleAssembler groupBiWithCollect(AbstractRuleAssembler ruleAssembler, Supplier<? extends DroolsAbstractGroupByAccumulator<InTuple>> invokerSupplier) {
        return this.universalGroupWithCollect(ruleAssembler, invokerSupplier, (var, pattern, accumulate) -> this.regroupBiToTri(ruleAssembler, (Variable)var, (ViewItem)pattern, (ViewItem)accumulate));
    }

    protected <InTuple> AbstractRuleAssembler groupBiWithCollectBi(AbstractRuleAssembler ruleAssembler, Supplier<? extends DroolsAbstractGroupByAccumulator<InTuple>> invokerSupplier) {
        return this.universalGroupWithCollect(ruleAssembler, invokerSupplier, (var, pattern, accumulate) -> this.regroupBiToQuad(ruleAssembler, (Variable)var, (ViewItem)pattern, (ViewItem)accumulate));
    }

    protected <NewA> AbstractRuleAssembler recollect(AbstractRuleAssembler ruleAssembler, Variable<NewA> newA, ViewItem accumulatePattern) {
        ArrayList<ViewItem> newFinishedExpressions = new ArrayList<ViewItem>(ruleAssembler.getFinishedExpressions());
        newFinishedExpressions.add(accumulatePattern);
        PatternDSL.PatternDef newPrimaryPattern = PatternDSL.pattern(newA);
        return new UniRuleAssembler(ruleAssembler, ruleAssembler.getExpectedGroupByCount(), newFinishedExpressions, Collections.singletonList(newA), Collections.singletonList(newPrimaryPattern), Collections.emptyMap());
    }

    public <NewA> AbstractRuleAssembler regroup(AbstractRuleAssembler ruleAssembler, Variable<Collection<NewA>> newASource, ViewItem collectPattern, ViewItem accumulatePattern) {
        ruleAssembler.applyFilterToLastPrimaryPattern();
        ArrayList<ViewItem> newFinishedExpressions = new ArrayList<ViewItem>(ruleAssembler.getFinishedExpressions());
        newFinishedExpressions.add(accumulatePattern);
        newFinishedExpressions.add(collectPattern);
        Variable newA = ruleAssembler.createVariable("uniGrouped", (DeclarationSource)DSL.from(newASource));
        PatternDSL.PatternDef newPrimaryPattern = PatternDSL.pattern(newA);
        return new UniRuleAssembler(ruleAssembler, ruleAssembler.getExpectedGroupByCount(), newFinishedExpressions, Collections.singletonList(newA), Collections.singletonList(newPrimaryPattern), Collections.emptyMap());
    }

    public <NewA, NewB> AbstractRuleAssembler regroupBi(AbstractRuleAssembler ruleAssembler, Variable<Collection<BiTuple<NewA, NewB>>> newSource, ViewItem collectPattern, ViewItem accumulatePattern) {
        ruleAssembler.applyFilterToLastPrimaryPattern();
        Variable<BiTuple> newTuple = ruleAssembler.createVariable(BiTuple.class, "biGrouped", (DeclarationSource)DSL.from(newSource));
        ArrayList<ViewItem> newFinishedExpressions = new ArrayList<ViewItem>(ruleAssembler.getFinishedExpressions());
        newFinishedExpressions.add(accumulatePattern);
        newFinishedExpressions.add(collectPattern);
        Variable newA = ruleAssembler.createVariable("newA");
        Variable newB = ruleAssembler.createVariable("newB");
        List<Variable> newVariables = Arrays.asList(newA, newB);
        PatternDSL.PatternDef newPrimaryPattern = PatternDSL.pattern(newTuple).bind(newTuple, (Function1 & Serializable)tuple -> tuple).bind(newA, (Function1 & Serializable)tuple -> tuple.a).bind(newB, (Function1 & Serializable)tuple -> tuple.b);
        return new BiRuleAssembler(ruleAssembler, ruleAssembler.getExpectedGroupByCount(), newFinishedExpressions, newVariables, Collections.singletonList(newPrimaryPattern), Collections.emptyMap());
    }

    public <NewA, NewB, NewC> AbstractRuleAssembler regroupBiToTri(AbstractRuleAssembler ruleAssembler, Variable<Set<TriTuple<NewA, NewB, NewC>>> newSource, ViewItem collectPattern, ViewItem accumulatePattern) {
        ruleAssembler.applyFilterToLastPrimaryPattern();
        ArrayList<ViewItem> newFinishedExpressions = new ArrayList<ViewItem>(ruleAssembler.getFinishedExpressions());
        newFinishedExpressions.add(accumulatePattern);
        newFinishedExpressions.add(collectPattern);
        Variable newA = ruleAssembler.createVariable("newA");
        Variable newB = ruleAssembler.createVariable("newB");
        Variable newC = ruleAssembler.createVariable("newC");
        List<Variable> newVariables = Arrays.asList(newA, newB, newC);
        Variable<TriTuple> newTuple = ruleAssembler.createVariable(TriTuple.class, "triGrouped", (DeclarationSource)DSL.from(newSource));
        PatternDSL.PatternDef newPrimaryPattern = PatternDSL.pattern(newTuple).bind(newTuple, (Function1 & Serializable)tuple -> tuple).bind(newA, (Function1 & Serializable)tuple -> tuple.a).bind(newB, (Function1 & Serializable)tuple -> tuple.b).bind(newC, (Function1 & Serializable)tuple -> tuple.c);
        return new TriRuleAssembler(ruleAssembler, ruleAssembler.getExpectedGroupByCount(), newFinishedExpressions, newVariables, Collections.singletonList(newPrimaryPattern), Collections.emptyMap());
    }

    public <NewA, NewB, NewC, NewD> AbstractRuleAssembler regroupBiToQuad(AbstractRuleAssembler ruleAssembler, Variable<Set<QuadTuple<NewA, NewB, NewC, NewD>>> newSource, ViewItem collectPattern, ViewItem accumulatePattern) {
        ruleAssembler.applyFilterToLastPrimaryPattern();
        ArrayList<ViewItem> newFinishedExpressions = new ArrayList<ViewItem>(ruleAssembler.getFinishedExpressions());
        newFinishedExpressions.add(accumulatePattern);
        newFinishedExpressions.add(collectPattern);
        Variable newA = ruleAssembler.createVariable("newA");
        Variable newB = ruleAssembler.createVariable("newB");
        Variable newC = ruleAssembler.createVariable("newC");
        Variable newD = ruleAssembler.createVariable("newD");
        List<Variable> newVariables = Arrays.asList(newA, newB, newC, newD);
        Variable<QuadTuple> newTuple = ruleAssembler.createVariable(QuadTuple.class, "quadGrouped", (DeclarationSource)DSL.from(newSource));
        PatternDSL.PatternDef newPrimaryPattern = PatternDSL.pattern(newTuple).bind(newTuple, (Function1 & Serializable)tuple -> tuple).bind(newA, (Function1 & Serializable)tuple -> tuple.a).bind(newB, (Function1 & Serializable)tuple -> tuple.b).bind(newC, (Function1 & Serializable)tuple -> tuple.c).bind(newD, (Function1 & Serializable)tuple -> tuple.d);
        return new QuadRuleAssembler(ruleAssembler, ruleAssembler.getExpectedGroupByCount(), newFinishedExpressions, newVariables, Collections.singletonList(newPrimaryPattern), Collections.emptyMap());
    }

    protected UniRuleAssembler downgrade(BiRuleAssembler ruleAssembler) {
        List<Variable> allVariablesButLast = ruleAssembler.getVariables().subList(0, ruleAssembler.getVariables().size() - 1);
        return new UniRuleAssembler(ruleAssembler, ruleAssembler.getExpectedGroupByCount(), ruleAssembler.getFinishedExpressions(), allVariablesButLast, ruleAssembler.getPrimaryPatterns(), Collections.emptyMap());
    }

    protected BiRuleAssembler downgrade(TriRuleAssembler ruleAssembler) {
        List<Variable> allVariablesButLast = ruleAssembler.getVariables().subList(0, ruleAssembler.getVariables().size() - 1);
        return new BiRuleAssembler(ruleAssembler, ruleAssembler.getExpectedGroupByCount(), ruleAssembler.getFinishedExpressions(), allVariablesButLast, ruleAssembler.getPrimaryPatterns(), Collections.emptyMap());
    }

    @FunctionalInterface
    protected static interface Transformer<InTuple>
    extends TriFunction<Variable<Collection<InTuple>>, PatternDSL.PatternDef<Collection<InTuple>>, ViewItem<?>, AbstractRuleAssembler> {
    }
}

