/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.drools.model.Argument;
import org.drools.model.DeclarationSource;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.view.ViewItem;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.FactTuple;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelGroupingNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNodeType;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.FromNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractGroupByMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.RuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.RuleAssembly;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniRuleAssembler;

abstract class AbstractRuleAssembler<Predicate_>
implements RuleAssembler,
DroolsVariableFactory {
    private final DroolsVariableFactory variableFactory;
    private final int expectedGroupByCount;
    private final List<Variable> variables;
    private final List<ViewItem> finishedExpressions;
    private final List<PatternDSL.PatternDef> primaryPatterns;
    private final Map<Integer, List<ViewItem>> dependentExpressionMap;

    protected AbstractRuleAssembler(DroolsVariableFactory variableFactory, ConstraintGraphNode fromNode, int expectedGroupByCount) {
        this(variableFactory, expectedGroupByCount, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
        this.variables.add(this.createVariable(((FromNode)fromNode).getFactType(), "var"));
        this.primaryPatterns.add(PatternDSL.pattern((Variable)this.variables.get(0)));
    }

    protected AbstractRuleAssembler(DroolsVariableFactory variableFactory, int expectedGroupByCount, List<ViewItem> finishedExpressions, List<Variable> variables, List<PatternDSL.PatternDef> primaryPatterns, Map<Integer, List<ViewItem>> dependentExpressionMap) {
        this.variableFactory = variableFactory;
        this.expectedGroupByCount = expectedGroupByCount;
        this.finishedExpressions = new ArrayList<ViewItem>(finishedExpressions);
        this.variables = new ArrayList<Variable>(variables);
        this.primaryPatterns = new ArrayList<PatternDSL.PatternDef>(primaryPatterns);
        this.dependentExpressionMap = new HashMap<Integer, List<ViewItem>>(dependentExpressionMap);
    }

    protected static void impactScore(Drools drools, AbstractScoreHolder scoreHolder) {
        RuleContext kcontext = (RuleContext)drools;
        scoreHolder.impactScore(kcontext);
    }

    protected static void impactScore(DroolsConstraint constraint, Drools drools, AbstractScoreHolder scoreHolder, int impact) {
        RuleContext kcontext = (RuleContext)drools;
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore(kcontext, impact);
    }

    protected static void impactScore(DroolsConstraint constraint, Drools drools, AbstractScoreHolder scoreHolder, long impact) {
        RuleContext kcontext = (RuleContext)drools;
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore(kcontext, impact);
    }

    protected static void impactScore(DroolsConstraint constraint, Drools drools, AbstractScoreHolder scoreHolder, BigDecimal impact) {
        RuleContext kcontext = (RuleContext)drools;
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore(kcontext, impact);
    }

    int getExpectedGroupByCount() {
        return this.expectedGroupByCount;
    }

    List<Variable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    Variable getVariable(int index) {
        return this.variables.get(index);
    }

    List<PatternDSL.PatternDef> getPrimaryPatterns() {
        return Collections.unmodifiableList(this.primaryPatterns);
    }

    PatternDSL.PatternDef getLastPrimaryPattern() {
        return this.primaryPatterns.get(this.primaryPatterns.size() - 1);
    }

    protected abstract void addFilterToLastPrimaryPattern(Predicate_ var1);

    protected abstract void applyFilterToLastPrimaryPattern();

    Map<Integer, List<ViewItem>> getDependentExpressionMap() {
        return Collections.unmodifiableMap(this.dependentExpressionMap);
    }

    void addDependentExpressionToLastPattern(ViewItem expression) {
        int lastPatternId = this.primaryPatterns.size() - 1;
        this.dependentExpressionMap.computeIfAbsent(lastPatternId, key -> new ArrayList(1)).add(expression);
    }

    List<ViewItem> getFinishedExpressions() {
        return Collections.unmodifiableList(this.finishedExpressions);
    }

    @Override
    public final AbstractRuleAssembler andThen(ConstraintGraphNode node) {
        switch (node.getType()) {
            case FILTER: {
                return this.andThenFilter(node);
            }
            case IF_EXISTS: 
            case IF_NOT_EXISTS: {
                AbstractConstraintModelJoiningNode joiningNode = (AbstractConstraintModelJoiningNode)node;
                boolean shouldExist = joiningNode.getType() == ConstraintGraphNodeType.IF_EXISTS;
                return this.andThenExists(joiningNode, shouldExist);
            }
            case GROUPBY_MAPPING_ONLY: 
            case GROUPBY_COLLECTING_ONLY: 
            case GROUPBY_MAPPING_AND_COLLECTING: {
                AbstractConstraintModelGroupingNode groupingNode = (AbstractConstraintModelGroupingNode)node;
                return this.andThenGroupBy(groupingNode);
            }
        }
        throw new UnsupportedOperationException(node.getType().toString());
    }

    @Override
    public final RuleAssembler join(RuleAssembler ruleAssembler, ConstraintGraphNode joinNode) {
        if (!(ruleAssembler instanceof UniRuleAssembler)) {
            throw new IllegalStateException("Impossible state: Rule assembler (" + ruleAssembler + ") not instance of " + UniRuleAssembler.class + ".");
        }
        return this.join((UniRuleAssembler)ruleAssembler, joinNode);
    }

    protected abstract AbstractRuleAssembler join(UniRuleAssembler var1, ConstraintGraphNode var2);

    protected final AbstractRuleAssembler andThenFilter(ConstraintGraphNode filterNode) {
        Object predicate = ((Supplier)((Object)filterNode)).get();
        this.addFilterToLastPrimaryPattern(predicate);
        return this;
    }

    protected abstract AbstractRuleAssembler andThenExists(AbstractConstraintModelJoiningNode var1, boolean var2);

    protected final AbstractRuleAssembler andThenGroupBy(AbstractConstraintModelGroupingNode groupingNode) {
        List mappings = groupingNode.getMappings();
        int mappingCount = mappings.size();
        List collectors = groupingNode.getCollectors();
        int collectorCount = collectors.size();
        switch (groupingNode.getType()) {
            case GROUPBY_MAPPING_ONLY: {
                switch (mappingCount) {
                    case 1: {
                        return (AbstractRuleAssembler)this.new1Map0CollectGroupByMutator(mappings.get(0)).apply(this);
                    }
                    case 2: {
                        return (AbstractRuleAssembler)this.new2Map0CollectGroupByMutator(mappings.get(0), mappings.get(1)).apply(this);
                    }
                }
                throw new UnsupportedOperationException("Impossible state: Mapping count (" + mappingCount + ").");
            }
            case GROUPBY_COLLECTING_ONLY: {
                if (collectorCount == 1) {
                    return (AbstractRuleAssembler)this.new0Map1CollectGroupByMutator(collectors.get(0)).apply(this);
                }
                throw new UnsupportedOperationException("Impossible state: Collector count (" + collectorCount + ").");
            }
            case GROUPBY_MAPPING_AND_COLLECTING: {
                if (mappingCount == 1 && collectorCount == 1) {
                    return (AbstractRuleAssembler)this.new1Map1CollectGroupByMutator(mappings.get(0), collectors.get(0)).apply(this);
                }
                if (mappingCount == 2 && collectorCount == 1) {
                    return (AbstractRuleAssembler)this.new2Map1CollectGroupByMutator(mappings.get(0), mappings.get(1), collectors.get(0)).apply(this);
                }
                if (mappingCount == 2 && collectorCount == 2) {
                    return (AbstractRuleAssembler)this.new2Map2CollectGroupByMutator(mappings.get(0), mappings.get(1), collectors.get(0), collectors.get(1)).apply(this);
                }
                throw new UnsupportedOperationException("Impossible state: Mapping count (" + mappingCount + "), collector count (" + collectorCount + ").");
            }
        }
        throw new UnsupportedOperationException(groupingNode.getType().toString());
    }

    protected abstract AbstractGroupByMutator new0Map1CollectGroupByMutator(Object var1);

    protected abstract AbstractGroupByMutator new1Map0CollectGroupByMutator(Object var1);

    protected abstract AbstractGroupByMutator new1Map1CollectGroupByMutator(Object var1, Object var2);

    protected abstract AbstractGroupByMutator new2Map0CollectGroupByMutator(Object var1, Object var2);

    protected abstract AbstractGroupByMutator new2Map1CollectGroupByMutator(Object var1, Object var2, Object var3);

    protected abstract AbstractGroupByMutator new2Map2CollectGroupByMutator(Object var1, Object var2, Object var3, Object var4);

    protected abstract ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint var1, Global<? extends AbstractScoreHolder<?>> var2, Variable ... var3);

    @Override
    public RuleAssembly assemble(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, DroolsConstraint constraint) {
        this.applyFilterToLastPrimaryPattern();
        ArrayList<Object> ruleItemBuilderList = new ArrayList<Object>(0);
        ruleItemBuilderList.addAll(this.finishedExpressions);
        for (int i = 0; i < this.primaryPatterns.size(); ++i) {
            ruleItemBuilderList.add((RuleItemBuilder)this.primaryPatterns.get(i));
            ruleItemBuilderList.addAll(this.dependentExpressionMap.getOrDefault(i, Collections.emptyList()));
        }
        ConsequenceBuilder.ValidBuilder consequence = this.buildConsequence(constraint, scoreHolderGlobal, this.variables.toArray(new Variable[0]));
        ruleItemBuilderList.add(consequence);
        Rule rule = PatternDSL.rule((String)constraint.getConstraintPackage(), (String)constraint.getConstraintName()).build(ruleItemBuilderList.toArray(new RuleItemBuilder[0]));
        return new RuleAssembly(rule, (Class[])this.getExpectedJustificationTypes().toArray(Class[]::new));
    }

    private Stream<Class> getExpectedJustificationTypes() {
        PatternDSL.PatternDef pattern = this.primaryPatterns.get(this.primaryPatterns.size() - 1);
        Class type = pattern.getFirstVariable().getType();
        if (FactTuple.class.isAssignableFrom(type)) {
            return Stream.of(type);
        }
        return this.variables.stream().map(Argument::getType);
    }

    @Override
    public <X> Variable<? extends X> createVariable(Class<X> clz, String baseName) {
        return this.variableFactory.createVariable(clz, baseName);
    }

    @Override
    public <X> Variable<? extends X> createVariable(String baseName, DeclarationSource source) {
        return this.variableFactory.createVariable(baseName, source);
    }

    @Override
    public <X> Variable<? extends X> createVariable(Class<X> clz, String baseName, DeclarationSource source) {
        return this.variableFactory.createVariable(clz, baseName, source);
    }
}

