/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.drools.model.BetaIndex;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate2;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.JoinMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.Mutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniRuleAssembler;

final class BiJoinMutator<A, B>
implements JoinMutator<UniRuleAssembler, BiRuleAssembler> {
    private final AbstractBiJoiner<A, B> biJoiner;

    public BiJoinMutator(AbstractConstraintModelJoiningNode<B, AbstractBiJoiner<A, B>> node) {
        this.biJoiner = (AbstractBiJoiner)node.get().get(0);
    }

    @Override
    public BiRuleAssembler apply(UniRuleAssembler leftRuleAssembler, UniRuleAssembler rightRuleAssembler) {
        Function leftMapping;
        JoinerType[] joinerTypes = this.biJoiner.getJoinerTypes();
        PatternDSL.PatternDef aJoiner = leftRuleAssembler.getLastPrimaryPattern();
        Variable[] joinVars = new Variable[joinerTypes.length];
        int mappingIndex = 0;
        while (mappingIndex < joinerTypes.length) {
            int currentMappingIndex = mappingIndex++;
            Variable joinVar = leftRuleAssembler.createVariable("joinVar" + currentMappingIndex);
            leftMapping = this.biJoiner.getLeftMapping(currentMappingIndex);
            aJoiner.bind(joinVar, (Function1 & Serializable)a -> leftMapping.apply(a));
            joinVars[currentMappingIndex] = joinVar;
        }
        PatternDSL.PatternDef bJoiner = rightRuleAssembler.getLastPrimaryPattern();
        for (int mappingIndex2 = 0; mappingIndex2 < joinerTypes.length; ++mappingIndex2) {
            JoinerType joinerType = joinerTypes[mappingIndex2];
            leftMapping = this.biJoiner.getLeftMapping(mappingIndex2);
            Function<B, Object> rightMapping = this.biJoiner.getRightMapping(mappingIndex2);
            Function1 & Serializable rightExtractor = rightMapping::apply;
            Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(a, rightExtractor.apply(b));
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)Mutator.getConstraintType(joinerType), (int)mappingIndex2, (Function1)rightExtractor, leftMapping::apply);
            bJoiner.expr("Join using joiner #" + mappingIndex2 + " in " + this.biJoiner, joinVars[mappingIndex2], (Predicate2)predicate, index);
        }
        return (BiRuleAssembler)this.merge(leftRuleAssembler, rightRuleAssembler);
    }

    @Override
    public BiRuleAssembler newRuleAssembler(UniRuleAssembler leftRuleAssembler, UniRuleAssembler rightRuleAssembler, List<ViewItem> finishedExpressions, List<Variable> variables, List<PatternDSL.PatternDef> primaryPatterns, Map<Integer, List<ViewItem>> dependentExpressionMap) {
        return new BiRuleAssembler(leftRuleAssembler, Math.max(leftRuleAssembler.getExpectedGroupByCount(), rightRuleAssembler.getExpectedGroupByCount()), finishedExpressions, variables, primaryPatterns, dependentExpressionMap);
    }
}

