/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractBiCollectingGroupByCollectorProcessor;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;

final class DroolsTriToQuadGroupByCollectorProcessor<A, B, C, NewA, NewB, NewC, NewD, ResultContainerC, ResultContainerD>
extends DroolsAbstractBiCollectingGroupByCollectorProcessor<ResultContainerC, ResultContainerD, TriTuple<A, B, C>, BiTuple<NewA, NewB>, QuadTuple<NewA, NewB, NewC, NewD>> {
    private final TriFunction<A, B, C, NewA> groupKeyAMapping;
    private final TriFunction<A, B, C, NewB> groupKeyBMapping;
    private final Supplier<ResultContainerC> supplierC;
    private final QuadFunction<ResultContainerC, A, B, C, Runnable> accumulatorC;
    private final Function<ResultContainerC, NewC> finisherC;
    private final Supplier<ResultContainerD> supplierD;
    private final QuadFunction<ResultContainerD, A, B, C, Runnable> accumulatorD;
    private final Function<ResultContainerD, NewD> finisherD;

    public DroolsTriToQuadGroupByCollectorProcessor(TriFunction<A, B, C, NewA> groupKeyAMapping, TriFunction<A, B, C, NewB> groupKeyBMapping, TriConstraintCollector<A, B, C, ResultContainerC, NewC> collectorC, TriConstraintCollector<A, B, C, ResultContainerD, NewD> collectorD) {
        this.groupKeyAMapping = groupKeyAMapping;
        this.groupKeyBMapping = groupKeyBMapping;
        this.supplierC = collectorC.supplier();
        this.accumulatorC = collectorC.accumulator();
        this.finisherC = collectorC.finisher();
        this.supplierD = collectorD.supplier();
        this.accumulatorD = collectorD.accumulator();
        this.finisherD = collectorD.finisher();
    }

    @Override
    protected BiTuple<NewA, NewB> toKey(TriTuple<A, B, C> tuple) {
        return new BiTuple<NewA, NewB>(this.groupKeyAMapping.apply(tuple.a, tuple.b, tuple.c), this.groupKeyBMapping.apply(tuple.a, tuple.b, tuple.c));
    }

    @Override
    protected ResultContainerC newFirstContainer() {
        return this.supplierC.get();
    }

    @Override
    protected ResultContainerD newSecondContainer() {
        return this.supplierD.get();
    }

    @Override
    protected Runnable processFirst(TriTuple<A, B, C> tuple, ResultContainerC container) {
        return this.accumulatorC.apply(container, tuple.a, tuple.b, tuple.c);
    }

    @Override
    protected Runnable processSecond(TriTuple<A, B, C> tuple, ResultContainerD container) {
        return this.accumulatorD.apply(container, tuple.a, tuple.b, tuple.c);
    }

    @Override
    protected QuadTuple<NewA, NewB, NewC, NewD> toResult(BiTuple<NewA, NewB> key, ResultContainerC containerC, ResultContainerD containerD) {
        return new QuadTuple(key.a, key.b, this.finisherC.apply(containerC), this.finisherD.apply(containerD));
    }
}

