/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.ConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNodeType;

public abstract class AbstractConstraintModelNode
implements ConstraintGraphNode {
    private final List<ConstraintGraphNode> childNodeList = new ArrayList<ConstraintGraphNode>(0);
    private final List<ConstraintConsequence> consequenceList = new ArrayList<ConstraintConsequence>(0);
    private final ConstraintGraphNodeType type;

    AbstractConstraintModelNode(ConstraintGraphNodeType type) {
        this.type = Objects.requireNonNull(type);
    }

    public final void addChildNode(ConstraintGraphNode node) {
        ConstraintGraphNode nonNullNode = Objects.requireNonNull(node);
        if (this.childNodeList.contains(nonNullNode)) {
            throw new IllegalStateException("Node (" + this + ") already has this child node (" + nonNullNode + ").");
        }
        this.childNodeList.add(nonNullNode);
    }

    public final void addConsequence(ConstraintConsequence consequence) {
        ConstraintConsequence nonNullConsequence = Objects.requireNonNull(consequence);
        if (this.consequenceList.contains(nonNullConsequence)) {
            throw new IllegalStateException("Node (" + this + ") already has this consequence (" + nonNullConsequence + ").");
        }
        this.consequenceList.add(nonNullConsequence);
    }

    @Override
    public final List<ConstraintGraphNode> getChildNodes() {
        return Collections.unmodifiableList(this.childNodeList);
    }

    @Override
    public final List<ConstraintConsequence> getConsequences() {
        return Collections.unmodifiableList(this.consequenceList);
    }

    @Override
    public final ConstraintGraphNodeType getType() {
        return this.type;
    }
}

