/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySorterManner;
import org.optaplanner.core.config.heuristic.selector.value.ValueSorterManner;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;
import org.optaplanner.core.impl.solver.thread.DefaultSolverThreadFactory;

public class HeuristicConfigPolicy<Solution_> {
    private final EnvironmentMode environmentMode;
    private final String logIndentation;
    private final Integer moveThreadCount;
    private final Integer moveThreadBufferSize;
    private final Class<? extends ThreadFactory> threadFactoryClass;
    private final InnerScoreDirectorFactory<Solution_, ?> scoreDirectorFactory;
    private EntitySorterManner entitySorterManner = EntitySorterManner.NONE;
    private ValueSorterManner valueSorterManner = ValueSorterManner.NONE;
    private boolean reinitializeVariableFilterEnabled = false;
    private boolean initializedChainedValueFilterEnabled = false;
    private Map<String, EntityMimicRecorder<Solution_>> entityMimicRecorderMap = new HashMap<String, EntityMimicRecorder<Solution_>>();
    private Map<String, ValueMimicRecorder<Solution_>> valueMimicRecorderMap = new HashMap<String, ValueMimicRecorder<Solution_>>();

    public HeuristicConfigPolicy(EnvironmentMode environmentMode, Integer moveThreadCount, Integer moveThreadBufferSize, Class<? extends ThreadFactory> threadFactoryClass, InnerScoreDirectorFactory<Solution_, ?> scoreDirectorFactory) {
        this(environmentMode, "", moveThreadCount, moveThreadBufferSize, threadFactoryClass, scoreDirectorFactory);
    }

    public HeuristicConfigPolicy(EnvironmentMode environmentMode, String logIndentation, Integer moveThreadCount, Integer moveThreadBufferSize, Class<? extends ThreadFactory> threadFactoryClass, InnerScoreDirectorFactory<Solution_, ?> scoreDirectorFactory) {
        this.environmentMode = environmentMode;
        this.logIndentation = logIndentation;
        this.moveThreadCount = moveThreadCount;
        this.moveThreadBufferSize = moveThreadBufferSize;
        this.threadFactoryClass = threadFactoryClass;
        this.scoreDirectorFactory = scoreDirectorFactory;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public String getLogIndentation() {
        return this.logIndentation;
    }

    public Integer getMoveThreadCount() {
        return this.moveThreadCount;
    }

    public Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public Integer getMoveThreadBufferSize() {
        return this.moveThreadBufferSize;
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.scoreDirectorFactory.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDirectorFactory.getScoreDefinition();
    }

    public InnerScoreDirectorFactory<Solution_, ?> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    public EntitySorterManner getEntitySorterManner() {
        return this.entitySorterManner;
    }

    public void setEntitySorterManner(EntitySorterManner entitySorterManner) {
        this.entitySorterManner = entitySorterManner;
    }

    public ValueSorterManner getValueSorterManner() {
        return this.valueSorterManner;
    }

    public void setValueSorterManner(ValueSorterManner valueSorterManner) {
        this.valueSorterManner = valueSorterManner;
    }

    public boolean isReinitializeVariableFilterEnabled() {
        return this.reinitializeVariableFilterEnabled;
    }

    public Map<String, EntityMimicRecorder<Solution_>> getEntityMimicRecorderMap() {
        return this.entityMimicRecorderMap;
    }

    public void setEntityMimicRecorderMap(Map<String, EntityMimicRecorder<Solution_>> entityMimicRecorderMap) {
        this.entityMimicRecorderMap = entityMimicRecorderMap;
    }

    public Map<String, ValueMimicRecorder<Solution_>> getValueMimicRecorderMap() {
        return this.valueMimicRecorderMap;
    }

    public void setValueMimicRecorderMap(Map<String, ValueMimicRecorder<Solution_>> valueMimicRecorderMap) {
        this.valueMimicRecorderMap = valueMimicRecorderMap;
    }

    public boolean isInitializedChainedValueFilterEnabled() {
        return this.initializedChainedValueFilterEnabled;
    }

    public HeuristicConfigPolicy<Solution_> createPhaseConfigPolicy() {
        return new HeuristicConfigPolicy<Solution_>(this.environmentMode, this.logIndentation, this.moveThreadCount, this.moveThreadBufferSize, this.threadFactoryClass, this.scoreDirectorFactory);
    }

    public HeuristicConfigPolicy<Solution_> createFilteredPhaseConfigPolicy() {
        HeuristicConfigPolicy<Solution_> heuristicConfigPolicy = this.createPhaseConfigPolicy();
        heuristicConfigPolicy.reinitializeVariableFilterEnabled = true;
        heuristicConfigPolicy.initializedChainedValueFilterEnabled = true;
        return heuristicConfigPolicy;
    }

    public HeuristicConfigPolicy<Solution_> createChildThreadConfigPolicy(ChildThreadType childThreadType) {
        return new HeuristicConfigPolicy<Solution_>(this.environmentMode, this.logIndentation + "        ", this.moveThreadCount, this.moveThreadBufferSize, this.threadFactoryClass, this.scoreDirectorFactory);
    }

    public void addEntityMimicRecorder(String id, EntityMimicRecorder<Solution_> mimicRecordingEntitySelector) {
        EntityMimicRecorder<Solution_> put = this.entityMimicRecorderMap.put(id, mimicRecordingEntitySelector);
        if (put != null) {
            throw new IllegalStateException("Multiple " + EntityMimicRecorder.class.getSimpleName() + "s (usually " + EntitySelector.class.getSimpleName() + "s) have the same id (" + id + ").");
        }
    }

    public EntityMimicRecorder<Solution_> getEntityMimicRecorder(String id) {
        return this.entityMimicRecorderMap.get(id);
    }

    public void addValueMimicRecorder(String id, ValueMimicRecorder<Solution_> mimicRecordingValueSelector) {
        ValueMimicRecorder<Solution_> put = this.valueMimicRecorderMap.put(id, mimicRecordingValueSelector);
        if (put != null) {
            throw new IllegalStateException("Multiple " + ValueMimicRecorder.class.getSimpleName() + "s (usually " + ValueSelector.class.getSimpleName() + "s) have the same id (" + id + ").");
        }
    }

    public ValueMimicRecorder<Solution_> getValueMimicRecorder(String id) {
        return this.valueMimicRecorderMap.get(id);
    }

    public ThreadFactory buildThreadFactory(ChildThreadType childThreadType) {
        String threadPrefix;
        if (this.threadFactoryClass != null) {
            return ConfigUtils.newInstance(this::toString, "threadFactoryClass", this.threadFactoryClass);
        }
        switch (childThreadType) {
            case MOVE_THREAD: {
                threadPrefix = "MoveThread";
                break;
            }
            case PART_THREAD: {
                threadPrefix = "PartThread";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported childThreadType (" + childThreadType + ").");
            }
        }
        return new DefaultSolverThreadFactory(threadPrefix);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.environmentMode + ")";
    }
}

