/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.stream.bi.FilteringBiJoiner;

public abstract class InnerConstraintFactory<Solution_, Constraint_ extends Constraint>
implements ConstraintFactory {
    @Override
    public <A> UniConstraintStream<A> from(Class<A> fromClass) {
        UniConstraintStream<Object> stream = this.fromUnfiltered(fromClass);
        EntityDescriptor<Solution_> entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(fromClass);
        if (entityDescriptor != null && entityDescriptor.hasAnyGenuineVariables()) {
            Predicate<Object> predicate = entityDescriptor.getIsInitializedPredicate();
            stream = stream.filter(predicate);
        }
        return stream;
    }

    @Override
    public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> fromClass, BiJoiner<A, A> joiner) {
        MemberAccessor planningIdMemberAccessor = ConfigUtils.findPlanningIdMemberAccessor(fromClass, this.getSolutionDescriptor().getDomainAccessType(), this.getSolutionDescriptor().getGeneratedMemberAccessorMap());
        if (planningIdMemberAccessor == null) {
            throw new IllegalArgumentException("The fromClass (" + fromClass + ") has no member with a @" + PlanningId.class.getSimpleName() + " annotation, so the pairs cannot be made unique ([A,B] vs [B,A]).");
        }
        Function<Object, Comparable> planningIdGetter = fact -> (Comparable)planningIdMemberAccessor.executeGetter(fact);
        if (joiner instanceof FilteringBiJoiner) {
            BiPredicate filter = ((FilteringBiJoiner)joiner).getFilter();
            return this.from(fromClass).join(fromClass, Joiners.lessThan(planningIdGetter)).filter(filter);
        }
        return this.from(fromClass).join(fromClass, joiner, Joiners.lessThan(planningIdGetter));
    }

    public <A> void assertValidFromType(Class<A> fromType) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Set<Class<?>> problemFactOrEntityClassSet = solutionDescriptor.getProblemFactOrEntityClassSet();
        boolean hasMatchingType = problemFactOrEntityClassSet.stream().anyMatch(factType -> fromType.isAssignableFrom((Class<?>)factType) || factType.isAssignableFrom(fromType));
        if (!hasMatchingType) {
            List canonicalClassNameList = problemFactOrEntityClassSet.stream().map(Class::getCanonicalName).sorted().collect(Collectors.toList());
            throw new IllegalArgumentException("Cannot use class (" + fromType.getCanonicalName() + ") in a constraint stream as it is neither the same as, nor a superclass or superinterface of one of planning entities or problem facts.\nEnsure that all from(), join(), ifExists() and ifNotExists() building blocks only reference classes assignable from planning entities or problem facts (" + canonicalClassNameList + ") annotated on the planning solution (" + solutionDescriptor.getSolutionClass().getCanonicalName() + ").");
        }
    }

    public List<Constraint_> buildConstraints(ConstraintProvider constraintProvider) {
        Constraint[] constraints = constraintProvider.defineConstraints(this);
        if (constraints == null) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not return null.\nMaybe return an empty array instead if there are no constraints.");
        }
        List constraintList = Arrays.stream(constraints).map(c -> c).collect(Collectors.toList());
        if (constraintList.stream().anyMatch(Objects::isNull)) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not contain an element that is null.\nMaybe don't include any null elements in the " + Constraint.class.getSimpleName() + " array.");
        }
        Map<String, List<Constraint>> constraintsPerIdMap = constraintList.stream().collect(Collectors.groupingBy(Constraint::getConstraintId));
        constraintsPerIdMap.forEach((constraintId, duplicateConstraintList) -> {
            if (duplicateConstraintList.size() > 1) {
                throw new IllegalStateException("There are multiple constraints with the same ID (" + constraintId + ").");
            }
        });
        return constraintList;
    }

    public abstract SolutionDescriptor<Solution_> getSolutionDescriptor();
}

