/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMoveSelector;

public class SwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, SwapMoveSelectorConfig> {
    public SwapMoveSelectorFactory(SwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        EntitySelectorConfig entitySelectorConfig_ = ((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig() == null ? new EntitySelectorConfig() : ((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig();
        EntitySelector leftEntitySelector = EntitySelectorFactory.create(entitySelectorConfig_).buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        EntitySelectorConfig rightEntitySelectorConfig = Objects.requireNonNullElse(((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig(), entitySelectorConfig_);
        EntitySelector rightEntitySelector = EntitySelectorFactory.create(rightEntitySelectorConfig).buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        List variableDescriptorList = this.deduceVariableDescriptorList(leftEntitySelector.getEntityDescriptor(), ((SwapMoveSelectorConfig)this.config).getVariableNameIncludeList());
        return new SwapMoveSelector(leftEntitySelector, rightEntitySelector, variableDescriptorList, randomSelection);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntityDescriptor onlySecondaryEntityDescriptor;
        EntityDescriptor onlyEntityDescriptor;
        EntityDescriptor entityDescriptor = onlyEntityDescriptor = ((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig() == null ? null : EntitySelectorFactory.create(((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig()).extractEntityDescriptor(configPolicy);
        if (((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig() != null && onlyEntityDescriptor != (onlySecondaryEntityDescriptor = EntitySelectorFactory.create(((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig()).extractEntityDescriptor(configPolicy))) {
            throw new IllegalArgumentException("The entitySelector (" + ((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig() + ")'s entityClass (" + (onlyEntityDescriptor == null ? null : onlyEntityDescriptor.getEntityClass()) + ") and secondaryEntitySelectorConfig (" + ((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig() + ")'s entityClass (" + (onlySecondaryEntityDescriptor == null ? null : onlySecondaryEntityDescriptor.getEntityClass()) + ") must be the same entity class.");
        }
        if (onlyEntityDescriptor != null) {
            return null;
        }
        Collection<EntityDescriptor<Solution_>> entityDescriptors = configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
        return this.buildUnfoldedMoveSelectorConfig(entityDescriptors);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(Collection<EntityDescriptor<Solution_>> entityDescriptors) {
        ArrayList<MoveSelectorConfig> moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(entityDescriptors.size());
        for (EntityDescriptor<Solution_> entityDescriptor : entityDescriptors) {
            SwapMoveSelectorConfig childMoveSelectorConfig = new SwapMoveSelectorConfig();
            EntitySelectorConfig childEntitySelectorConfig = new EntitySelectorConfig(((SwapMoveSelectorConfig)this.config).getEntitySelectorConfig());
            if (childEntitySelectorConfig.getMimicSelectorRef() == null) {
                childEntitySelectorConfig.setEntityClass(entityDescriptor.getEntityClass());
            }
            childMoveSelectorConfig.setEntitySelectorConfig(childEntitySelectorConfig);
            if (((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig() != null) {
                EntitySelectorConfig childSecondaryEntitySelectorConfig = new EntitySelectorConfig(((SwapMoveSelectorConfig)this.config).getSecondaryEntitySelectorConfig());
                if (childSecondaryEntitySelectorConfig.getMimicSelectorRef() == null) {
                    childSecondaryEntitySelectorConfig.setEntityClass(entityDescriptor.getEntityClass());
                }
                childMoveSelectorConfig.setSecondaryEntitySelectorConfig(childSecondaryEntitySelectorConfig);
            }
            childMoveSelectorConfig.setVariableNameIncludeList(((SwapMoveSelectorConfig)this.config).getVariableNameIncludeList());
            moveSelectorConfigList.add(childMoveSelectorConfig);
        }
        MoveSelectorConfig unfoldedMoveSelectorConfig = moveSelectorConfigList.size() == 1 ? (MoveSelectorConfig)moveSelectorConfigList.get(0) : new UnionMoveSelectorConfig(moveSelectorConfigList);
        unfoldedMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        return unfoldedMoveSelectorConfig;
    }
}

