/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simple;

import java.util.Objects;
import org.optaplanner.core.api.score.AbstractScore;

public final class SimpleScore
extends AbstractScore<SimpleScore> {
    public static final SimpleScore ZERO = new SimpleScore(0, 0);
    public static final SimpleScore ONE = new SimpleScore(0, 1);
    private final int score;

    public static SimpleScore parseScore(String scoreString) {
        String[] scoreTokens = SimpleScore.parseScoreTokens(SimpleScore.class, scoreString, "");
        int initScore = SimpleScore.parseInitScore(SimpleScore.class, scoreString, scoreTokens[0]);
        int score = SimpleScore.parseLevelAsInt(SimpleScore.class, scoreString, scoreTokens[1]);
        return SimpleScore.ofUninitialized(initScore, score);
    }

    public static SimpleScore ofUninitialized(int initScore, int score) {
        return new SimpleScore(initScore, score);
    }

    public static SimpleScore of(int score) {
        return new SimpleScore(0, score);
    }

    private SimpleScore() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private SimpleScore(int initScore, int score) {
        super(initScore);
        this.score = score;
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public SimpleScore withInitScore(int newInitScore) {
        return new SimpleScore(newInitScore, this.score);
    }

    @Override
    public SimpleScore add(SimpleScore addend) {
        return new SimpleScore(this.initScore + addend.getInitScore(), this.score + addend.getScore());
    }

    @Override
    public SimpleScore subtract(SimpleScore subtrahend) {
        return new SimpleScore(this.initScore - subtrahend.getInitScore(), this.score - subtrahend.getScore());
    }

    @Override
    public SimpleScore multiply(double multiplicand) {
        return new SimpleScore((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleScore divide(double divisor) {
        return new SimpleScore((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.score / divisor));
    }

    @Override
    public SimpleScore power(double exponent) {
        return new SimpleScore((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.score, exponent)));
    }

    @Override
    public SimpleScore negate() {
        return new SimpleScore(-this.initScore, -this.score);
    }

    @Override
    public SimpleScore zero() {
        return ZERO;
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleScore) {
            SimpleScore other = (SimpleScore)o;
            return this.initScore == other.getInitScore() && this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.score);
    }

    @Override
    public int compareTo(SimpleScore other) {
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        return Integer.compare(this.score, other.getScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> n.intValue() != 0, "");
    }

    public String toString() {
        return this.getInitPrefix() + this.score;
    }
}

