/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common.inliner;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.stream.common.inliner.WeightedScoreImpacter;

final class HardMediumSoftBigDecimalScoreInliner
extends AbstractScoreInliner<HardMediumSoftBigDecimalScore> {
    private BigDecimal hardScore = BigDecimal.ZERO;
    private BigDecimal mediumScore = BigDecimal.ZERO;
    private BigDecimal softScore = BigDecimal.ZERO;

    HardMediumSoftBigDecimalScoreInliner(Map<Constraint, HardMediumSoftBigDecimalScore> constraintToWeightMap, boolean constraintMatchEnabled) {
        super(constraintToWeightMap, constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        HardMediumSoftBigDecimalScore constraintWeight = (HardMediumSoftBigDecimalScore)this.getConstraintWeight(constraint);
        BigDecimal hardConstraintWeight = constraintWeight.getHardScore();
        BigDecimal mediumConstraintWeight = constraintWeight.getMediumScore();
        BigDecimal softConstraintWeight = constraintWeight.getSoftScore();
        if (mediumConstraintWeight.equals(BigDecimal.ZERO) && softConstraintWeight.equals(BigDecimal.ZERO)) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                BigDecimal hardImpact = hardConstraintWeight.multiply(matchWeight);
                this.hardScore = this.hardScore.add(hardImpact);
                UndoScoreImpacter undoScoreImpact = () -> {
                    this.hardScore = this.hardScore.subtract(hardImpact);
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardMediumSoftBigDecimalScore.ofHard(hardImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        if (hardConstraintWeight.equals(BigDecimal.ZERO) && softConstraintWeight.equals(BigDecimal.ZERO)) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                BigDecimal mediumImpact = mediumConstraintWeight.multiply(matchWeight);
                this.mediumScore = this.mediumScore.add(mediumImpact);
                UndoScoreImpacter undoScoreImpact = () -> {
                    this.mediumScore = this.mediumScore.subtract(mediumImpact);
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardMediumSoftBigDecimalScore.ofMedium(mediumImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        if (hardConstraintWeight.equals(BigDecimal.ZERO) && mediumConstraintWeight.equals(BigDecimal.ZERO)) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                BigDecimal softImpact = softConstraintWeight.multiply(matchWeight);
                this.softScore = this.softScore.add(softImpact);
                UndoScoreImpacter undoScoreImpact = () -> {
                    this.softScore = this.softScore.subtract(softImpact);
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardMediumSoftBigDecimalScore.ofSoft(softImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            BigDecimal hardImpact = hardConstraintWeight.multiply(matchWeight);
            BigDecimal mediumImpact = mediumConstraintWeight.multiply(matchWeight);
            BigDecimal softImpact = softConstraintWeight.multiply(matchWeight);
            this.hardScore = this.hardScore.add(hardImpact);
            this.mediumScore = this.mediumScore.add(mediumImpact);
            this.softScore = this.softScore.add(softImpact);
            UndoScoreImpacter undoScoreImpact = () -> {
                this.hardScore = this.hardScore.subtract(hardImpact);
                this.mediumScore = this.mediumScore.subtract(mediumImpact);
                this.softScore = this.softScore.subtract(softImpact);
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardMediumSoftBigDecimalScore.of(hardImpact, mediumImpact, softImpact), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public HardMediumSoftBigDecimalScore extractScore(int initScore) {
        return HardMediumSoftBigDecimalScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    public String toString() {
        return HardMediumSoftBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

