/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.valuerange.descriptor.CompositeValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.FromEntityPropertyValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.FromSolutionPropertyValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.NullValueReinitializeVariableEntityFilter;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.MovableChainedTrailingValueFilter;

public abstract class GenuineVariableDescriptor<Solution_>
extends VariableDescriptor<Solution_> {
    private ValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private SelectionFilter<Solution_, Object> movableChainedTrailingValueFilter;
    private SelectionFilter<Solution_, Object> reinitializeVariableEntityFilter = new NullValueReinitializeVariableEntityFilter(this);
    private SelectionSorter<Solution_, Object> increasingStrengthSorter;
    private SelectionSorter<Solution_, Object> decreasingStrengthSorter;

    public GenuineVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    protected abstract void processPropertyAnnotations(DescriptorPolicy var1);

    protected void processValueRangeRefs(DescriptorPolicy descriptorPolicy, String[] valueRangeProviderRefs) {
        if (valueRangeProviderRefs == null || valueRangeProviderRefs.length == 0) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") that has no valueRangeProviderRefs (" + Arrays.toString(valueRangeProviderRefs) + ").");
        }
        ArrayList valueRangeDescriptorList = new ArrayList(valueRangeProviderRefs.length);
        boolean addNullInValueRange = this.isNullable() && valueRangeProviderRefs.length == 1;
        for (String valueRangeProviderRef : valueRangeProviderRefs) {
            valueRangeDescriptorList.add(this.buildValueRangeDescriptor(descriptorPolicy, valueRangeProviderRef, addNullInValueRange));
        }
        this.valueRangeDescriptor = valueRangeDescriptorList.size() == 1 ? (ValueRangeDescriptor)valueRangeDescriptorList.get(0) : new CompositeValueRangeDescriptor(this, this.isNullable(), valueRangeDescriptorList);
    }

    private ValueRangeDescriptor<Solution_> buildValueRangeDescriptor(DescriptorPolicy descriptorPolicy, String valueRangeProviderRef, boolean addNullInValueRange) {
        if (descriptorPolicy.hasFromSolutionValueRangeProvider(valueRangeProviderRef)) {
            MemberAccessor memberAccessor = descriptorPolicy.getFromSolutionValueRangeProvider(valueRangeProviderRef);
            return new FromSolutionPropertyValueRangeDescriptor(this, addNullInValueRange, memberAccessor);
        }
        if (descriptorPolicy.hasFromEntityValueRangeProvider(valueRangeProviderRef)) {
            MemberAccessor memberAccessor = descriptorPolicy.getFromEntityValueRangeProvider(valueRangeProviderRef);
            return new FromEntityPropertyValueRangeDescriptor(this, addNullInValueRange, memberAccessor);
        }
        Collection<String> providerIds = descriptorPolicy.getValueRangeProviderIds();
        throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a valueRangeProviderRef (" + valueRangeProviderRef + ") that does not exist in a @" + ValueRangeProvider.class.getSimpleName() + " on the solution class (" + this.entityDescriptor.getSolutionDescriptor().getSolutionClass().getSimpleName() + ") or on that entityClass.\nThe valueRangeProviderRef (" + valueRangeProviderRef + ") does not appear in the valueRangeProvideIds (" + providerIds + ")." + (String)(!providerIds.isEmpty() ? "" : "\nMaybe a @" + ValueRangeProvider.class.getSimpleName() + " annotation is missing on a method in the solution class (" + this.entityDescriptor.getSolutionDescriptor().getSolutionClass().getSimpleName() + ")."));
    }

    protected void processStrength(DescriptorPolicy descriptorPolicy, Class<? extends Comparator> strengthComparatorClass, Class<? extends SelectionSorterWeightFactory> strengthWeightFactoryClass) {
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if (strengthWeightFactoryClass == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") property (" + this.variableMemberAccessor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        if (strengthComparatorClass != null) {
            Comparator strengthComparator = ConfigUtils.newInstance(this::toString, "strengthComparatorClass", strengthComparatorClass);
            this.increasingStrengthSorter = new ComparatorSelectionSorter<Solution_, Object>(strengthComparator, SelectionSorterOrder.ASCENDING);
            this.decreasingStrengthSorter = new ComparatorSelectionSorter<Solution_, Object>(strengthComparator, SelectionSorterOrder.DESCENDING);
        }
        if (strengthWeightFactoryClass != null) {
            SelectionSorterWeightFactory strengthWeightFactory = ConfigUtils.newInstance(this::toString, "strengthWeightFactoryClass", strengthWeightFactoryClass);
            this.increasingStrengthSorter = new WeightFactorySelectionSorter<Solution_, Object>(strengthWeightFactory, SelectionSorterOrder.ASCENDING);
            this.decreasingStrengthSorter = new WeightFactorySelectionSorter<Solution_, Object>(strengthWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.movableChainedTrailingValueFilter = this.isChained() && this.entityDescriptor.hasEffectiveMovableEntitySelectionFilter() ? new MovableChainedTrailingValueFilter(this) : null;
    }

    public abstract boolean isListVariable();

    public abstract boolean isChained();

    public abstract boolean isNullable();

    public abstract boolean acceptsValueType(Class<?> var1);

    public boolean hasMovableChainedTrailingValueFilter() {
        return this.movableChainedTrailingValueFilter != null;
    }

    public SelectionFilter<Solution_, Object> getMovableChainedTrailingValueFilter() {
        return this.movableChainedTrailingValueFilter;
    }

    public ValueRangeDescriptor<Solution_> getValueRangeDescriptor() {
        return this.valueRangeDescriptor;
    }

    public boolean isValueRangeEntityIndependent() {
        return this.valueRangeDescriptor.isEntityIndependent();
    }

    public abstract boolean isInitialized(Object var1);

    @Override
    public boolean isGenuineAndUninitialized(Object entity) {
        return !this.isInitialized(entity);
    }

    public boolean isReinitializable(ScoreDirector<Solution_> scoreDirector, Object entity) {
        return this.reinitializeVariableEntityFilter.accept(scoreDirector, entity);
    }

    public SelectionSorter<Solution_, Object> getIncreasingStrengthSorter() {
        return this.increasingStrengthSorter;
    }

    public SelectionSorter<Solution_, Object> getDecreasingStrengthSorter() {
        return this.decreasingStrengthSorter;
    }

    public long getValueCount(Solution_ solution, Object entity) {
        if (!this.valueRangeDescriptor.isCountable()) {
            return 0L;
        }
        return ((CountableValueRange)this.valueRangeDescriptor.extractValueRange(solution, entity)).getSize();
    }

    public String toString() {
        return this.getSimpleEntityAndVariableName() + " variable";
    }
}

