/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.index;

import java.util.List;
import java.util.Objects;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class IndexVariableListener<Solution_>
implements VariableListener<Solution_, Object>,
IndexVariableSupply {
    protected final IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    public IndexVariableListener(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public boolean requiresUniqueEntityEvents() {
        return true;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void afterVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    protected void insert(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        int index = 0;
        for (Object value : listVariable) {
            Integer oldIndex = this.shadowVariableDescriptor.getValue(value);
            if (oldIndex != null) {
                throw new IllegalStateException("The entity (" + entity + ") has a list variable (" + this.sourceVariableDescriptor.getVariableName() + ") and one of its values (" + value + ") which has a shadow variable (" + this.shadowVariableDescriptor.getVariableName() + ") has an oldIndex (" + oldIndex + ") which is not null.\nVerify the consistency of your input problem for that shadow variable.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, value);
            this.shadowVariableDescriptor.setValue(value, index);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, value);
            ++index;
        }
    }

    protected void retract(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        int index = 0;
        for (Object value : listVariable) {
            Integer oldIndex = this.shadowVariableDescriptor.getValue(value);
            if (!Objects.equals(oldIndex, index)) {
                throw new IllegalStateException("The entity (" + entity + ") has a list variable (" + this.sourceVariableDescriptor.getVariableName() + ") and one of its values (" + value + ") which has a shadow variable (" + this.shadowVariableDescriptor.getVariableName() + ") is at index (" + index + ") and has an unexpected oldIndex (" + oldIndex + ").\nVerify the consistency of your input problem for that shadow variable.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, value);
            this.shadowVariableDescriptor.setValue(value, null);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, value);
            ++index;
        }
    }

    @Override
    public Integer getIndex(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

