/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.decorator;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.AbstractEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class FilteringEntitySelector<Solution_>
extends AbstractEntitySelector<Solution_> {
    protected final EntitySelector<Solution_> childEntitySelector;
    protected final List<SelectionFilter<Solution_, Object>> filterList;
    protected final boolean bailOutEnabled;
    protected ScoreDirector<Solution_> scoreDirector = null;

    public FilteringEntitySelector(EntitySelector<Solution_> childEntitySelector, List<SelectionFilter<Solution_, Object>> filterList) {
        this.childEntitySelector = childEntitySelector;
        this.filterList = filterList;
        this.bailOutEnabled = childEntitySelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childEntitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childEntitySelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childEntitySelector.getSize();
    }

    @Override
    public Iterator<Object> iterator() {
        return new JustInTimeFilteringEntityIterator(this.childEntitySelector.iterator(), this.determineBailOutSize());
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Object> endingIterator() {
        return new JustInTimeFilteringEntityIterator(this.childEntitySelector.endingIterator(), this.determineBailOutSize());
    }

    protected long determineBailOutSize() {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        return this.childEntitySelector.getSize() * 10L;
    }

    protected boolean accept(ScoreDirector<Solution_> scoreDirector, Object entity) {
        for (SelectionFilter<Solution_, Object> filter : this.filterList) {
            if (filter.accept(scoreDirector, entity)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Filtering(" + this.childEntitySelector + ")";
    }

    protected class JustInTimeFilteringEntityIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> childEntityIterator;
        private final long bailOutSize;

        public JustInTimeFilteringEntityIterator(Iterator<Object> childEntityIterator, long bailOutSize) {
            this.childEntityIterator = childEntityIterator;
            this.bailOutSize = bailOutSize;
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            long attemptsBeforeBailOut = this.bailOutSize;
            do {
                if (!this.childEntityIterator.hasNext()) {
                    return this.noUpcomingSelection();
                }
                if (!FilteringEntitySelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringEntitySelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringEntitySelector.this);
                    return this.noUpcomingSelection();
                }
                --attemptsBeforeBailOut;
            } while (!FilteringEntitySelector.this.accept(FilteringEntitySelector.this.scoreDirector, next = this.childEntityIterator.next()));
            return next;
        }
    }
}

