/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class ListUnassignMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object sourceEntity;
    private final int sourceIndex;

    public ListUnassignMove(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex) {
        this.variableDescriptor = variableDescriptor;
        this.sourceEntity = sourceEntity;
        this.sourceIndex = sourceIndex;
    }

    private Object getMovedValue() {
        return this.variableDescriptor.getElement(this.sourceEntity, this.sourceIndex);
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    @Override
    public AbstractMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        throw new UnsupportedOperationException("Undoing an unassign move is unsupported.");
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        innerScoreDirector.beforeVariableChanged(this.variableDescriptor, this.sourceEntity);
        this.variableDescriptor.removeElement(this.sourceEntity, this.sourceIndex);
        innerScoreDirector.afterVariableChanged(this.variableDescriptor, this.sourceEntity);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListUnassignMove other = (ListUnassignMove)o;
        return this.sourceIndex == other.sourceIndex && Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.sourceEntity, other.sourceEntity);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.sourceEntity, this.sourceIndex);
    }

    public String toString() {
        return String.format("%s {%s[%d] -> null}", this.getMovedValue(), this.sourceEntity, this.sourceIndex);
    }
}

