/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Collections;
import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListSwapMove;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;

public class OriginalListSwapIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final SingletonInverseVariableSupply inverseVariableSupply;
    private final IndexVariableSupply indexVariableSupply;
    private final Iterator<Object> leftValueIterator;
    private final EntityIndependentValueSelector<Solution_> rightValueSelector;
    private Iterator<Object> rightValueIterator;
    private Object upcomingLeftEntity;
    private Integer upcomingLeftIndex;

    public OriginalListSwapIterator(ListVariableDescriptor<Solution_> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, IndexVariableSupply indexVariableSupply, EntityIndependentValueSelector<Solution_> leftValueSelector, EntityIndependentValueSelector<Solution_> rightValueSelector) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.indexVariableSupply = indexVariableSupply;
        this.leftValueIterator = leftValueSelector.iterator();
        this.rightValueIterator = Collections.emptyIterator();
        this.rightValueSelector = rightValueSelector;
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        while (!this.rightValueIterator.hasNext()) {
            if (!this.leftValueIterator.hasNext()) {
                return (Move)this.noUpcomingSelection();
            }
            Object upcomingLeftValue = this.leftValueIterator.next();
            this.upcomingLeftEntity = this.inverseVariableSupply.getInverseSingleton(upcomingLeftValue);
            this.upcomingLeftIndex = this.indexVariableSupply.getIndex(upcomingLeftValue);
            this.rightValueIterator = this.rightValueSelector.iterator();
        }
        Object upcomingRightValue = this.rightValueIterator.next();
        return new ListSwapMove<Solution_>(this.listVariableDescriptor, this.upcomingLeftEntity, this.upcomingLeftIndex, this.inverseVariableSupply.getInverseSingleton(upcomingRightValue), this.indexVariableSupply.getIndex(upcomingRightValue));
    }
}

