/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drl;

import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;
import org.optaplanner.core.impl.score.director.drl.DrlScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drl.OptaPlannerRuleEventListener;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;

public class DrlScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, DrlScoreDirectorFactory<Solution_, Score_>> {
    public static final String GLOBAL_SCORE_HOLDER_KEY = "scoreHolder";
    protected KieSession kieSession;
    protected AbstractScoreHolder<Score_> scoreHolder;

    public DrlScoreDirector(DrlScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public KieSession getKieSession() {
        return this.kieSession;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.resetKieSession();
    }

    private void resetKieSession() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
        this.kieSession = ((DrlScoreDirectorFactory)this.scoreDirectorFactory).newKieSession();
        ((RuleEventManager)this.kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        this.resetScoreHolder();
        this.getSolutionDescriptor().visitAllFacts(this.workingSolution, arg_0 -> ((KieSession)this.kieSession).insert(arg_0));
    }

    private void resetScoreHolder() {
        this.scoreHolder = AbstractScoreHolder.buildScoreHolder(this.getScoreDefinition(), this.constraintMatchEnabledPreference);
        ((DrlScoreDirectorFactory)this.scoreDirectorFactory).getRuleToConstraintWeightExtractorMap().forEach((rule, extractor) -> {
            Score constraintWeight = (Score)extractor.apply(this.workingSolution);
            this.getSolutionDescriptor().validateConstraintWeight(rule.getPackageName(), rule.getName(), constraintWeight);
            this.scoreHolder.configureConstraintWeight((Rule)rule, constraintWeight);
        });
        this.kieSession.setGlobal(GLOBAL_SCORE_HOLDER_KEY, this.scoreHolder);
    }

    @Override
    public Score_ calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        this.kieSession.fireAllRules();
        Score_ score = this.scoreHolder.extractScore(this.workingInitScore);
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.scoreHolder.isConstraintMatchEnabled();
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getConstraintMatchTotalMap().");
        }
        this.kieSession.fireAllRules();
        return this.scoreHolder.getConstraintMatchTotalMap();
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getIndictmentMap().");
        }
        this.kieSession.fireAllRules();
        return this.scoreHolder.getIndictmentMap();
    }

    @Override
    public boolean requiresFlushing() {
        return true;
    }

    @Override
    public void close() {
        super.close();
        if (this.kieSession != null) {
            this.kieSession.dispose();
            this.kieSession = null;
        }
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @" + PlanningEntity.class.getSimpleName() + ".");
        }
        if (this.kieSession.getFactHandle(entity) != null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was already added to this ScoreDirector. Usually the cause is that that specific instance was already in your Solution's entities and you probably want to use before/afterVariableChanged() instead.");
        }
        this.kieSession.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.update(entity, variableDescriptor.getVariableName());
        super.afterVariableChanged(variableDescriptor, entity);
    }

    private void update(Object entity, String variableName) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the return values of the " + PlanningSolution.class.getSimpleName() + "'s entity members (" + this.getSolutionDescriptor().getEntityMemberAndEntityCollectionMemberNames() + ").");
        }
        this.kieSession.update(factHandle, entity, new String[]{variableName});
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the return values of the " + PlanningSolution.class.getSimpleName() + "'s entity members (" + this.getSolutionDescriptor().getEntityMemberAndEntityCollectionMemberNames() + ").");
        }
        this.kieSession.delete(factHandle);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (this.kieSession.getFactHandle(problemFact) != null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was already added to this ScoreDirector.\nMaybe that specific instance is already in the " + PlanningSolution.class.getSimpleName() + "'s problem fact members (" + this.getSolutionDescriptor().getProblemFactMemberAndProblemFactCollectionMemberNames() + ").\nMaybe use before/afterProblemPropertyChanged() instead of before/afterProblemFactAdded().");
        }
        this.kieSession.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFactOrEntity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFactOrEntity + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the " + PlanningSolution.class.getSimpleName() + "'s problem fact members (" + this.getSolutionDescriptor().getProblemFactMemberAndProblemFactCollectionMemberNames() + ").\nMaybe first translate that external instance to the workingSolution's instance with " + ScoreDirector.class.getSimpleName() + ".lookUpWorkingObject().");
        }
        this.kieSession.update(factHandle, problemFactOrEntity);
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the " + PlanningSolution.class.getSimpleName() + "'s problem fact members (" + this.getSolutionDescriptor().getProblemFactMemberAndProblemFactCollectionMemberNames() + ").\nMaybe first translate that external instance to the workingSolution's instance with " + ScoreDirector.class.getSimpleName() + ".lookUpWorkingObject().");
        }
        this.kieSession.delete(factHandle);
        super.afterProblemFactRemoved(problemFact);
    }
}

