/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drl.testgen.reproducer;

import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.ConsequenceException;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.director.drl.testgen.TestGenDrlScoreDirector;
import org.optaplanner.core.impl.score.director.drl.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drl.testgen.TestGenKieSessionListener;
import org.optaplanner.core.impl.score.director.drl.testgen.operation.TestGenKieSessionFireAllRules;
import org.optaplanner.core.impl.score.director.drl.testgen.reproducer.TestGenCorruptedScoreException;
import org.optaplanner.core.impl.score.director.drl.testgen.reproducer.TestGenOriginalProblemReproducer;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenCorruptedVariableListenerReproducer
implements TestGenOriginalProblemReproducer,
TestGenKieSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestGenCorruptedVariableListenerReproducer.class);
    private final String analysis;
    private final TestGenDrlScoreDirector<?, ?> scoreDirector;
    private Score<?> lastWorkingScore;
    private int lastFireId;

    public TestGenCorruptedVariableListenerReproducer(String analysis, TestGenDrlScoreDirector<?, ?> scoreDirector) {
        this.analysis = analysis;
        this.scoreDirector = scoreDirector;
    }

    private static Score<?> extractScore(KieSession kieSession) {
        AbstractScoreHolder sh = (AbstractScoreHolder)kieSession.getGlobal("scoreHolder");
        return sh.extractScore(0);
    }

    @Override
    public void assertReproducible(TestGenKieSessionJournal journal, String contextDescription) {
        if (!this.isReproducible(journal)) {
            throw new IllegalStateException(contextDescription + " Variable listeners are not corrupted.");
        }
    }

    @Override
    public boolean isReproducible(TestGenKieSessionJournal journal) {
        this.lastWorkingScore = null;
        this.lastFireId = Integer.MAX_VALUE;
        journal.addListener(this);
        try {
            journal.replay(this.scoreDirector.createKieSession());
            return false;
        }
        catch (TestGenCorruptedScoreException e) {
            return true;
        }
        catch (ConsequenceException e) {
            LOGGER.debug("    Journal pruning not possible: {}", (Object)e.toString());
            return false;
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("No fact handle for ")) {
                LOGGER.debug("    Can't remove insert: {}", (Object)e.toString());
            } else if (e.getMessage() != null && e.getMessage().startsWith("Error evaluating constraint '")) {
                LOGGER.debug("    Can't drop field setup: {}", (Object)e.toString());
            } else {
                LOGGER.info("Unexpected exception", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public void afterFireAllRules(KieSession kieSession, TestGenKieSessionJournal journal, TestGenKieSessionFireAllRules fire) {
        Score<?> workingScore = TestGenCorruptedVariableListenerReproducer.extractScore(kieSession);
        if (fire.isAssertFire()) {
            LOGGER.debug("    [Assert mode] Score: working[{}], uncorrupted[{}] ({})", new Object[]{workingScore, this.lastWorkingScore, fire});
            if (this.lastFireId == fire.getFireId() - 1 && !workingScore.equals(this.lastWorkingScore)) {
                throw new TestGenCorruptedScoreException(workingScore, this.lastWorkingScore);
            }
        } else {
            LOGGER.debug("      Score: {} ({})", workingScore, (Object)fire);
        }
        this.lastWorkingScore = workingScore;
        this.lastFireId = fire.getFireId();
    }

    public String toString() {
        return this.analysis;
    }
}

