/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.tri;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetScoringTriNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.stream.common.inliner.WeightedScoreImpacter;

public final class BavetScoringTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C> {
    private final BavetAbstractTriConstraintStream<Solution_, A, B, C> parent;
    private final BavetConstraint<Solution_> constraint;
    private final boolean noMatchWeigher;
    private final ToIntTriFunction<A, B, C> intMatchWeigher;
    private final ToLongTriFunction<A, B, C> longMatchWeigher;
    private final TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher;

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint) {
        this(constraintFactory, parent, constraint, true, null, null, null);
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint, ToIntTriFunction<A, B, C> intMatchWeigher) {
        this(constraintFactory, parent, constraint, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint, ToLongTriFunction<A, B, C> longMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint, boolean noMatchWeigher, ToIntTriFunction<A, B, C> intMatchWeigher, ToLongTriFunction<A, B, C> longMatchWeigher, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.constraint = constraint;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public List<BavetFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    @Override
    protected BavetScoringTriNode<A, B, C> createNode(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractTriNode<A, B, C> parentNode) {
        TriFunction<Object, Object, Object, UndoScoreImpacter> scoreImpacter;
        AbstractScoreInliner<?> scoreInliner = buildPolicy.getSession().getScoreInliner();
        WeightedScoreImpacter weightedScoreImpacter = scoreInliner.buildWeightedScoreImpacter(this.constraint);
        if (this.intMatchWeigher != null) {
            scoreImpacter = (a, b, c) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, () -> Arrays.asList(a, b, c));
            };
        } else if (this.longMatchWeigher != null) {
            scoreImpacter = (a, b, c) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, () -> Arrays.asList(a, b, c));
            };
        } else if (this.bigDecimalMatchWeigher != null) {
            scoreImpacter = (a, b, c) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, () -> Arrays.asList(a, b, c));
            };
        } else if (this.noMatchWeigher) {
            scoreImpacter = (a, b, c) -> weightedScoreImpacter.impactScore(1, () -> Arrays.asList(a, b, c));
        } else {
            throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
        }
        return new BavetScoringTriNode<Object, Object, Object>(buildPolicy.getSession(), buildPolicy.nextNodeIndex(), constraintWeight, scoreImpacter);
    }

    @Override
    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractTriNode<A, B, C> node) {
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's an endpoint.");
        }
    }

    public String toString() {
        return "Scoring()";
    }
}

