/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common.inliner;

import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.stream.common.inliner.WeightedScoreImpacter;

final class SimpleLongScoreInliner
extends AbstractScoreInliner<SimpleLongScore> {
    private long score;

    SimpleLongScoreInliner(Map<Constraint, SimpleLongScore> constraintToWeightMap, boolean constraintMatchEnabled) {
        super(constraintToWeightMap, constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        SimpleLongScore constraintWeight = (SimpleLongScore)this.getConstraintWeight(constraint);
        long simpleConstraintWeight = constraintWeight.getScore();
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            long impact = simpleConstraintWeight * matchWeight;
            this.score += impact;
            UndoScoreImpacter undoScoreImpact = () -> this.score -= impact;
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, SimpleLongScore.of(impact), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public SimpleLongScore extractScore(int initScore) {
        return SimpleLongScore.ofUninitialized(initScore, this.score);
    }

    public String toString() {
        return SimpleLongScore.class.getSimpleName() + " inliner";
    }
}

