/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.solver.ConsumerSupport;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverJob<Solution_, ProblemId_>
implements SolverJob<Solution_, ProblemId_>,
Callable<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSolverJob.class);
    private final DefaultSolverManager<Solution_, ProblemId_> solverManager;
    private final DefaultSolver<Solution_> solver;
    private final ProblemId_ problemId;
    private final Function<? super ProblemId_, ? extends Solution_> problemFinder;
    private final Consumer<? super Solution_> bestSolutionConsumer;
    private final Consumer<? super Solution_> finalBestSolutionConsumer;
    private final BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private volatile SolverStatus solverStatus;
    private final CountDownLatch terminatedLatch;
    private final ReentrantLock solverStatusModifyingLock;
    private Future<Solution_> finalBestSolutionFuture;
    private ConsumerSupport<Solution_, ProblemId_> consumerSupport;

    public DefaultSolverJob(DefaultSolverManager<Solution_, ProblemId_> solverManager, Solver<Solution_> solver, ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        this.solverManager = solverManager;
        this.problemId = problemId;
        if (!(solver instanceof DefaultSolver)) {
            throw new IllegalStateException("Impossible state: solver is not instance of " + DefaultSolver.class.getSimpleName() + ".");
        }
        this.solver = (DefaultSolver)solver;
        this.problemFinder = problemFinder;
        this.bestSolutionConsumer = bestSolutionConsumer;
        this.finalBestSolutionConsumer = finalBestSolutionConsumer;
        this.exceptionHandler = exceptionHandler;
        this.solverStatus = SolverStatus.SOLVING_SCHEDULED;
        this.terminatedLatch = new CountDownLatch(1);
        this.solverStatusModifyingLock = new ReentrantLock();
    }

    public void setFinalBestSolutionFuture(Future<Solution_> finalBestSolutionFuture) {
        this.finalBestSolutionFuture = finalBestSolutionFuture;
    }

    @Override
    public ProblemId_ getProblemId() {
        return this.problemId;
    }

    @Override
    public SolverStatus getSolverStatus() {
        return this.solverStatus;
    }

    @Override
    public Solution_ call() {
        this.solverStatusModifyingLock.lock();
        if (this.solverStatus != SolverStatus.SOLVING_SCHEDULED) {
            this.solverStatusModifyingLock.unlock();
            return this.problemFinder.apply(this.problemId);
        }
        try {
            this.solverStatus = SolverStatus.SOLVING_ACTIVE;
            this.consumerSupport = new ConsumerSupport<Solution_, ProblemId_>(this.getProblemId(), this.bestSolutionConsumer, this.finalBestSolutionConsumer, this.exceptionHandler);
            Solution_ problem = this.problemFinder.apply(this.problemId);
            this.solver.addPhaseLifecycleListener(new UnlockLockPhaseLifecycleListener());
            if (this.bestSolutionConsumer != null) {
                this.solver.addEventListener(event -> this.consumerSupport.consumeIntermediateBestSolution(event.getNewBestSolution()));
            }
            Solution_ finalBestSolution = this.solver.solve(problem);
            if (this.finalBestSolutionConsumer != null) {
                this.consumerSupport.consumeFinalBestSolution(finalBestSolution);
            }
            Solution_ Solution_ = finalBestSolution;
            return Solution_;
        }
        catch (Exception e) {
            this.exceptionHandler.accept(this.problemId, e);
            throw new IllegalStateException("Solving failed for problemId (" + this.problemId + ").", e);
        }
        finally {
            if (this.solverStatusModifyingLock.isHeldByCurrentThread()) {
                this.solverStatusModifyingLock.unlock();
            }
            this.solvingTerminated();
        }
    }

    private void solvingTerminated() {
        this.solverStatus = SolverStatus.NOT_SOLVING;
        this.solverManager.unregisterSolverJob(this.problemId);
        this.terminatedLatch.countDown();
    }

    @Override
    public void addProblemChange(ProblemChange<Solution_> problemChange) {
        Objects.requireNonNull(problemChange, () -> "A problem change (" + problemChange + ") must not be null.");
        if (this.solverStatus == SolverStatus.NOT_SOLVING) {
            throw new IllegalStateException("Cannot add the problem change (" + problemChange + ") because the solver job (" + this.solverStatus + ") is not solving.");
        }
        this.solver.addProblemChange(problemChange);
    }

    @Override
    public void terminateEarly() {
        try {
            this.solverStatusModifyingLock.lock();
            this.finalBestSolutionFuture.cancel(false);
            switch (this.solverStatus) {
                case SOLVING_SCHEDULED: {
                    this.solvingTerminated();
                    break;
                }
                case SOLVING_ACTIVE: {
                    this.solver.terminateEarly();
                    break;
                }
                case NOT_SOLVING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported solverStatus (" + this.solverStatus + ").");
                }
            }
            try {
                this.terminatedLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("The terminateEarly() call is interrupted.", (Throwable)e);
            }
        }
        finally {
            this.solverStatusModifyingLock.unlock();
        }
    }

    @Override
    public Solution_ getFinalBestSolution() throws InterruptedException, ExecutionException {
        return this.finalBestSolutionFuture.get();
    }

    @Override
    public Duration getSolvingDuration() {
        SolverScope<Solution_> solverScope = this.solver.getSolverScope();
        Long startingSystemTimeMillis = solverScope.getStartingSystemTimeMillis();
        if (startingSystemTimeMillis == null) {
            return Duration.ZERO;
        }
        Long endingSystemTimeMillis = solverScope.getEndingSystemTimeMillis();
        if (endingSystemTimeMillis == null) {
            endingSystemTimeMillis = System.currentTimeMillis();
        }
        return Duration.ofMillis(endingSystemTimeMillis - startingSystemTimeMillis);
    }

    void close() {
        if (this.consumerSupport != null) {
            this.consumerSupport.close();
            this.consumerSupport = null;
        }
    }

    private final class UnlockLockPhaseLifecycleListener
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private UnlockLockPhaseLifecycleListener() {
        }

        @Override
        public void solvingStarted(SolverScope<Solution_> solverScope) {
            if (DefaultSolverJob.this.solverStatusModifyingLock.isLocked()) {
                DefaultSolverJob.this.solverStatusModifyingLock.unlock();
            }
        }
    }
}

