/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorImplementor;

public class GizmoMemberAccessorFactory {
    private static Map<String, MemberAccessor> memberAccessorMap = new HashMap<String, MemberAccessor>();

    public static String getGeneratedClassName(Member member) {
        return member.getDeclaringClass().getPackage().getName() + ".$optaplanner$__" + member.getDeclaringClass().getSimpleName() + "$__" + member.getName();
    }

    public static void usePregeneratedMemberAccessorMap(Map<String, MemberAccessor> memberAccessorMap) {
        GizmoMemberAccessorFactory.memberAccessorMap = memberAccessorMap;
    }

    public static MemberAccessor buildGizmoMemberAccessor(Member member, Class<? extends Annotation> annotationClass) {
        String gizmoMemberAccessorClassName = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        return memberAccessorMap.computeIfAbsent(gizmoMemberAccessorClassName, key -> {
            try {
                Class.forName("io.quarkus.gizmo.ClassCreator", false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("When using the domainAccessType (" + (Object)((Object)DomainAccessType.GIZMO) + ") the classpath or modulepath must contain io.quarkus.gizmo:gizmo.\nMaybe add a dependency to io.quarkus.gizmo:gizmo.");
            }
            MemberAccessor accessor = GizmoMemberAccessorImplementor.createAccessorFor(member, annotationClass);
            return accessor;
        });
    }

    private GizmoMemberAccessorFactory() {
    }
}

