/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;

public class GizmoMemberAccessorImplementor {
    private static final Map<String, byte[]> classNameToBytecode = new HashMap<String, byte[]>();
    private static ClassLoader gizmoClassLoader = new ClassLoader(){

        @Override
        public String getName() {
            return "OptaPlanner Gizmo MemberAccessor ClassLoader";
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            if (classNameToBytecode.containsKey(name)) {
                byte[] byteCode = (byte[])classNameToBytecode.get(name);
                return this.defineClass(name, byteCode, 0, byteCode.length);
            }
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
    };
    static final String GENERIC_TYPE_FIELD = "genericType";
    static final String ANNOTATED_ELEMENT_FIELD = "annotatedElement";

    public static void defineAccessorFor(ClassCreator classCreator, GizmoMemberDescriptor member, Class<? extends Annotation> annotationClass) {
        classCreator.getFieldCreator(GENERIC_TYPE_FIELD, Type.class).setModifiers(16);
        classCreator.getFieldCreator(ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class).setModifiers(16);
        GizmoMemberInfo memberInfo = new GizmoMemberInfo(member, annotationClass);
        GizmoMemberAccessorImplementor.createConstructor(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createGetDeclaringClass(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createGetType(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createGetGenericType(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createGetName(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createGetSpeedNote(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createSupportSetter(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createExecuteGetter(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createExecuteSetter(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createIsAnnotationPresent(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createGetAnnotation(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createGetAnnotations(classCreator, memberInfo);
        GizmoMemberAccessorImplementor.createGetDeclaredAnnotations(classCreator, memberInfo);
    }

    public static MemberAccessor createAccessorFor(Member member, Class<? extends Annotation> annotationClass) {
        String className = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        if (classNameToBytecode.containsKey(className)) {
            return GizmoMemberAccessorImplementor.createInstance(className);
        }
        byte[][] classBytecodeHolder = new byte[1][];
        ClassOutput classOutput = (path, byteCode) -> {
            classBytecodeHolder[0] = byteCode;
        };
        try (ClassCreator classCreator = ClassCreator.builder().className(className).interfaces(new Class[]{MemberAccessor.class}).superClass(Object.class).classOutput(classOutput).build();){
            GizmoMemberDescriptor memberDescriptor = new GizmoMemberDescriptor(member);
            GizmoMemberAccessorImplementor.defineAccessorFor(classCreator, memberDescriptor, annotationClass);
        }
        byte[] classBytecode = classBytecodeHolder[0];
        classNameToBytecode.put(className, classBytecode);
        return GizmoMemberAccessorImplementor.createInstance(className);
    }

    private static MemberAccessor createInstance(String className) {
        try {
            return (MemberAccessor)gizmoClassLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static MethodCreator getMethodCreator(ClassCreator classCreator, String methodName, Class<?> ... parameters) {
        try {
            return classCreator.getMethodCreator(MethodDescriptor.ofMethod((Method)MemberAccessor.class.getMethod(methodName, parameters)));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such method: " + methodName, e);
        }
    }

    private static void createConstructor(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]));
        ResultHandle thisObj = methodCreator.getThis();
        methodCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
        ResultHandle declaringClass = methodCreator.loadClass(memberInfo.getDescriptor().getDeclaringClassName());
        memberInfo.getDescriptor().whenMetadataIsOnField(fd -> {
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle name = tryBlock.load(fd.getName());
            ResultHandle field = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), declaringClass, new ResultHandle[]{name});
            ResultHandle type = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Field.class, (String)"getGenericType", Type.class, (Class[])new Class[0]), field, new ResultHandle[0]);
            tryBlock.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj, type);
            tryBlock.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj, field);
            tryBlock.addCatch(NoSuchFieldException.class).throwException(IllegalStateException.class, "Unable to find field (" + fd.getName() + ") in class (" + fd.getDeclaringClass() + ").");
        });
        memberInfo.getDescriptor().whenMetadataIsOnMethod(md -> {
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle name = tryBlock.load(md.getName());
            ResultHandle method = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), declaringClass, new ResultHandle[]{name, tryBlock.newArray(Class.class, 0)});
            ResultHandle type = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"getGenericReturnType", Type.class, (Class[])new Class[0]), method, new ResultHandle[0]);
            tryBlock.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj, type);
            tryBlock.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj, method);
            tryBlock.addCatch(NoSuchMethodException.class).throwException(IllegalStateException.class, "Unable to find method (" + md.getName() + ") in class (" + md.getDeclaringClass() + ").");
        });
        methodCreator.returnValue(thisObj);
    }

    private static void createGetDeclaringClass(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getDeclaringClass", new Class[0]);
        ResultHandle out = methodCreator.loadClass(memberInfo.getDescriptor().getDeclaringClassName());
        methodCreator.returnValue(out);
    }

    private static void assertIsGoodMethod(MethodDescriptor method, Class<? extends Annotation> annotationClass) {
        String methodName = method.getName();
        if (method.getParameterTypes().length != 0) {
            throw new IllegalStateException("The getterMethod (" + methodName + ") with a " + annotationClass.getSimpleName() + " annotation must not have any parameters, but has parameters (" + Arrays.toString(method.getParameterTypes()) + ").");
        }
        if (methodName.startsWith("get")) {
            if (method.getReturnType().equals("V")) {
                throw new IllegalStateException("The getterMethod (" + methodName + ") with a " + annotationClass.getSimpleName() + " annotation must have a non-void return type.");
            }
        } else if (methodName.startsWith("is")) {
            if (!method.getReturnType().equals("boolean")) {
                throw new IllegalStateException("The getterMethod (" + methodName + ") with a " + annotationClass.getSimpleName() + " annotation must have a primitive boolean return type but returns (" + method.getReturnType() + "). Maybe rename the method (get" + methodName.substring(2) + ")?");
            }
        } else if (method.getReturnType().equals("V")) {
            throw new IllegalStateException("The readMethod (" + methodName + ") with a " + annotationClass.getSimpleName() + " annotation must have a non-void return type.");
        }
    }

    private static void createGetName(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getName", new Class[0]);
        memberInfo.getDescriptor().whenIsMethod(method -> GizmoMemberAccessorImplementor.assertIsGoodMethod(method, memberInfo.getAnnotationClass()));
        String fieldName = memberInfo.getDescriptor().getName();
        ResultHandle out = methodCreator.load(fieldName);
        methodCreator.returnValue(out);
    }

    private static void createGetType(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getType", new Class[0]);
        ResultHandle out = methodCreator.loadClass(memberInfo.getDescriptor().getTypeName());
        methodCreator.returnValue(out);
    }

    private static void createGetGenericType(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getGenericType", new Class[0]);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle out = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj);
        methodCreator.returnValue(out);
    }

    private static void createExecuteGetter(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "executeGetter", Object.class);
        ResultHandle bean = methodCreator.getMethodParam(0);
        memberInfo.getDescriptor().whenIsMethod(method -> {
            GizmoMemberAccessorImplementor.assertIsGoodMethod(method, memberInfo.getAnnotationClass());
            ResultHandle out = memberInfo.getDescriptor().invokeMemberMethod((BytecodeCreator)methodCreator, (MethodDescriptor)method, bean, new ResultHandle[0]);
            methodCreator.returnValue(out);
        });
        memberInfo.getDescriptor().whenIsField(field -> {
            ResultHandle out = methodCreator.readInstanceField(field, bean);
            methodCreator.returnValue(out);
        });
    }

    private static void createSupportSetter(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "supportSetter", new Class[0]);
        memberInfo.getDescriptor().whenIsMethod(method -> {
            boolean supportSetter = memberInfo.getDescriptor().getSetter().isPresent();
            ResultHandle out = methodCreator.load(supportSetter);
            methodCreator.returnValue(out);
        });
        memberInfo.getDescriptor().whenIsField(field -> {
            ResultHandle out = methodCreator.load(true);
            methodCreator.returnValue(out);
        });
    }

    private static void createExecuteSetter(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "executeSetter", Object.class, Object.class);
        memberInfo.getDescriptor().whenIsMethod(method -> {
            Optional<MethodDescriptor> setter = memberInfo.getDescriptor().getSetter();
            if (setter.isPresent()) {
                ResultHandle bean = methodCreator.getMethodParam(0);
                ResultHandle value = methodCreator.getMethodParam(1);
                memberInfo.getDescriptor().invokeMemberMethod((BytecodeCreator)methodCreator, setter.get(), bean, value);
                methodCreator.returnValue(null);
            } else {
                methodCreator.throwException(UnsupportedOperationException.class, "Setter not supported");
            }
        });
        memberInfo.getDescriptor().whenIsField(field -> {
            ResultHandle bean = methodCreator.getMethodParam(0);
            ResultHandle value = methodCreator.getMethodParam(1);
            methodCreator.writeInstanceField(field, bean, value);
            methodCreator.returnValue(null);
        });
    }

    private static void createGetSpeedNote(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getSpeedNote", new Class[0]);
        ResultHandle out = methodCreator.load("Fast access with generated bytecode");
        methodCreator.returnValue(out);
    }

    private static MethodCreator getAnnotationMethodCreator(ClassCreator classCreator, String methodName, Class<?> ... parameters) {
        return classCreator.getMethodCreator(GizmoMemberAccessorImplementor.getAnnotationMethod(methodName, parameters));
    }

    private static MethodDescriptor getAnnotationMethod(String methodName, Class<?> ... parameters) {
        try {
            return MethodDescriptor.ofMethod((Method)AnnotatedElement.class.getMethod(methodName, parameters));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such method: " + methodName, e);
        }
    }

    private static void createIsAnnotationPresent(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getAnnotationMethodCreator(classCreator, "isAnnotationPresent", Class.class);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle annotatedElement = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj);
        ResultHandle query = methodCreator.getMethodParam(0);
        ResultHandle out = methodCreator.invokeInterfaceMethod(GizmoMemberAccessorImplementor.getAnnotationMethod("isAnnotationPresent", Class.class), annotatedElement, new ResultHandle[]{query});
        methodCreator.returnValue(out);
    }

    private static void createGetAnnotation(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getAnnotationMethodCreator(classCreator, "getAnnotation", Class.class);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle annotatedElement = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj);
        ResultHandle query = methodCreator.getMethodParam(0);
        ResultHandle out = methodCreator.invokeInterfaceMethod(GizmoMemberAccessorImplementor.getAnnotationMethod("getAnnotation", Class.class), annotatedElement, new ResultHandle[]{query});
        methodCreator.returnValue(out);
    }

    private static void createGetAnnotations(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getAnnotationMethodCreator(classCreator, "getAnnotations", new Class[0]);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle annotatedElement = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj);
        ResultHandle out = methodCreator.invokeInterfaceMethod(GizmoMemberAccessorImplementor.getAnnotationMethod("getAnnotations", new Class[0]), annotatedElement, new ResultHandle[0]);
        methodCreator.returnValue(out);
    }

    private static void createGetDeclaredAnnotations(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getAnnotationMethodCreator(classCreator, "getDeclaredAnnotations", new Class[0]);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle annotatedElement = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj);
        ResultHandle out = methodCreator.invokeInterfaceMethod(GizmoMemberAccessorImplementor.getAnnotationMethod("getDeclaredAnnotations", new Class[0]), annotatedElement, new ResultHandle[0]);
        methodCreator.returnValue(out);
    }

    private GizmoMemberAccessorImplementor() {
    }

    private static class GizmoMemberInfo {
        private final GizmoMemberDescriptor descriptor;
        private final Class<? extends Annotation> annotationClass;

        public GizmoMemberInfo(GizmoMemberDescriptor descriptor, Class<? extends Annotation> annotationClass) {
            this.descriptor = descriptor;
            this.annotationClass = annotationClass;
        }

        public GizmoMemberDescriptor getDescriptor() {
            return this.descriptor;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }
    }
}

