/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.drools.model.DSL;
import org.drools.model.DeclarationSource;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;

final class DroolsVariableFactoryImpl
implements DroolsVariableFactory {
    private final AtomicLong counter = new AtomicLong(0L);

    DroolsVariableFactoryImpl() {
    }

    private String generateUniqueId(String baseName) {
        return baseName + "_" + this.counter.incrementAndGet();
    }

    @Override
    public <X> Variable<? extends X> createVariable(Class<X> clz, String baseName) {
        return DSL.declarationOf(clz, (String)this.generateUniqueId(baseName));
    }

    @Override
    public <X> Variable<X> createVariable(String baseName, Variable<X> source) {
        return DSL.declarationOf((Class)source.getType(), (String)this.generateUniqueId(baseName), (DeclarationSource)DSL.from(source, (Function1 & Serializable)x -> DroolsVariableFactoryImpl.sanitize(x)));
    }

    private static Object sanitize(Object value) {
        if (value instanceof Iterable) {
            return Collections.singleton(value);
        }
        return value;
    }

    @Override
    public <In, Out> Variable<Out> createVariable(String baseName, Variable<In> source, Function<In, Out> extractor) {
        return DSL.declarationOf(Object.class, (String)this.generateUniqueId(baseName), (DeclarationSource)DSL.from(source, (Function1 & Serializable)x -> {
            Object extracted = extractor.apply(x);
            return DroolsVariableFactoryImpl.sanitize(extracted);
        }));
    }
}

