/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.Supplier;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block6;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.ConsequenceMatchWeightType;
import org.optaplanner.core.impl.score.stream.drools.common.QuadLeftHandSide;

abstract class AbstractQuadConstraintConsequence<A, B, C, D>
extends AbstractConstraintConsequence<QuadLeftHandSide<A, B, C, D>> {
    AbstractQuadConstraintConsequence() {
    }

    @Override
    public int getCardinality() {
        return 4;
    }

    @Override
    protected abstract ConsequenceMatchWeightType getMatchWeightType();

    @Override
    protected final ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint<?> constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Variable<?> ... variables) {
        AbstractConstraintConsequence consequence = constraint.getConsequence();
        switch (consequence.getMatchWeightType()) {
            case INTEGER: {
                ToIntQuadFunction intMatchWeighter = (ToIntQuadFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1], variables[2], variables[3]).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> AbstractQuadConstraintConsequence.impactScore(constraint, drools, scoreHolder, intMatchWeighter.applyAsInt(a, b, c, d), a, b, c, d));
            }
            case LONG: {
                ToLongQuadFunction longMatchWeighter = (ToLongQuadFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1], variables[2], variables[3]).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> AbstractQuadConstraintConsequence.impactScore(constraint, drools, scoreHolder, longMatchWeighter.applyAsLong(a, b, c, d), a, b, c, d));
            }
            case BIG_DECIMAL: {
                QuadFunction bigDecimalMatchWeighter = (QuadFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1], variables[2], variables[3]).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> AbstractQuadConstraintConsequence.impactScore(constraint, drools, scoreHolder, (BigDecimal)bigDecimalMatchWeighter.apply(a, b, c, d), a, b, c, d));
            }
            case DEFAULT: {
                return DSL.on(scoreHolderGlobal, variables[0], variables[1], variables[2], variables[3]).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> AbstractQuadConstraintConsequence.impactScore(drools, scoreHolder, a, b, c, d));
            }
        }
        throw new UnsupportedOperationException(consequence.getMatchWeightType().toString());
    }
}

