/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.BetaIndex2;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractBiConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiConstraintBigDecimalConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.BiConstraintDefaultConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.BiConstraintIntConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.BiConstraintLongConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsBiAccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.UniLeftHandSide;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.FilteringTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class BiLeftHandSide<A, B>
extends AbstractLeftHandSide {
    private final PatternVariable<A> patternVariableA;
    private final PatternVariable<B> patternVariableB;

    protected BiLeftHandSide(PatternVariable<A> left, PatternVariable<B> right, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = left;
        this.patternVariableB = right;
    }

    protected BiLeftHandSide(BiLeftHandSide<A, B> leftHandSide, PatternVariable<B> patternVariable) {
        super(leftHandSide.variableFactory);
        this.patternVariableA = leftHandSide.patternVariableA;
        this.patternVariableB = patternVariable;
    }

    protected BiLeftHandSide(BiLeftHandSide<A, B> leftHandSide, PatternVariable<A> left, PatternVariable<B> right) {
        super(leftHandSide.variableFactory);
        this.patternVariableA = left;
        this.patternVariableB = right;
    }

    protected PatternVariable<A> getPatternVariableA() {
        return this.patternVariableA;
    }

    protected PatternVariable<B> getPatternVariableB() {
        return this.patternVariableB;
    }

    public BiLeftHandSide<A, B> andFilter(BiPredicate<A, B> predicate) {
        return new BiLeftHandSide<A, B>(this, this.patternVariableA, this.patternVariableB.filter(predicate, this.patternVariableA.getPrimaryVariable()));
    }

    private <C> BiLeftHandSide<A, B> applyJoiners(Class<C> otherFactType, AbstractTriJoiner<A, B, C> joiner, TriPredicate<A, B, C> predicate, boolean shouldExist) {
        Variable<C> toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            BiFunction leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate3 & Serializable joinPredicate = (Predicate3 & Serializable)(c, a, b) -> joinerType.matches(leftMapping.apply(a, b), rightMapping.apply(c));
            BetaIndex2 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)BiLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (Predicate3)joinPredicate, index);
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <C> BiLeftHandSide<A, B> applyFilters(PatternDSL.PatternDef<C> existencePattern, TriPredicate<A, B, C> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (Predicate3 & Serializable)(c, a, b) -> predicate.test(a, b, c));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new BiLeftHandSide<A, B>(this, this.patternVariableB.addDependentExpression((ViewItem<?>)existenceExpression));
    }

    private <C> BiLeftHandSide<A, B> existsOrNot(Class<C> cClass, TriJoiner<A, B, C>[] joiners, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        AbstractTriJoiner finalJoiner = null;
        TriPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractTriJoiner joiner = (AbstractTriJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NoneTriJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringTriJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractTriJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(cClass, finalJoiner, finalFilter, shouldExist);
    }

    public <C> BiLeftHandSide<A, B> andExists(Class<C> cClass, TriJoiner<A, B, C>[] joiners) {
        return this.existsOrNot(cClass, joiners, true);
    }

    public <C> BiLeftHandSide<A, B> andNotExists(Class<C> cClass, TriJoiner<A, B, C>[] joiners) {
        return this.existsOrNot(cClass, joiners, false);
    }

    public <C> TriLeftHandSide<A, B, C> andJoin(UniLeftHandSide<C> right, TriJoiner<A, B, C> joiner) {
        AbstractTriJoiner castJoiner = (AbstractTriJoiner)joiner;
        JoinerType[] joinerTypes = castJoiner.getJoinerTypes();
        PatternVariable<C> newRight = right.getPatternVariableA();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            newRight = newRight.filterForJoin(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), castJoiner, joinerType, mappingIndex);
        }
        return new TriLeftHandSide<A, B, C>(this.patternVariableA, this.patternVariableB, newRight, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(BiFunction<A, B, NewA> keyMapping) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, keyMapping::apply, (AccumulateFunction[])new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        return new UniLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(BiConstraintCollector<A, B, ?, NewA> collector) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> innerAccumulatePattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collector, accumulateSource, accumulateOutput), (AccumulateFunction[])new AccumulateFunction[0]);
        return new UniLeftHandSide(new PatternVariable(accumulateOutput, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(BiConstraintCollector<A, B, ?, NewA> collectorA, BiConstraintCollector<A, B, ?, NewB> collectorB) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> innerAccumulatePattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB)});
        return new BiLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(BiConstraintCollector<A, B, ?, NewA> collectorA, BiConstraintCollector<A, B, ?, NewB> collectorB, BiConstraintCollector<A, B, ?, NewC> collectorC) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> innerAccumulatePattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC)});
        return new TriLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), new PatternVariable(accumulateOutputC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(BiConstraintCollector<A, B, ?, NewA> collectorA, BiConstraintCollector<A, B, ?, NewB> collectorB, BiConstraintCollector<A, B, ?, NewC> collectorC, BiConstraintCollector<A, B, ?, NewD> collectorD) {
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> innerAccumulatePattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        return new QuadLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), new PatternVariable(accumulateOutputC), new PatternVariable(accumulateOutputD), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(BiConstraintCollector<A, B, ?, Out> collector, Variable<BiTuple<A, B>> in, Variable<Out> out) {
        return DSL.accFunction(() -> new DroolsBiAccumulateFunction(collector), in).as(out);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[0]);
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        return new BiLeftHandSide<Object, Object>(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiConstraintCollector<A, B, ?, NewB> collectorB) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, inputA, (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutput)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutput);
        return new BiLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiConstraintCollector<A, B, ?, NewB> collectorB, BiConstraintCollector<A, B, ?, NewC> collectorC) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, inputA, (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutputB);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        return new TriLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), new PatternVariable(newC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiConstraintCollector<A, B, ?, NewB> collectorB, BiConstraintCollector<A, B, ?, NewC> collectorC, BiConstraintCollector<A, B, ?, NewD> collectorD) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, inputA, (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutputB);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        Variable newD = this.variableFactory.createVariable("newD", accumulateOutputD);
        return new QuadLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), new PatternVariable(newC), new PatternVariable(newD), this.variableFactory);
    }

    private <NewA, NewB> Function2<A, B, BiTuple<NewA, NewB>> createCompositeBiGroupKey(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB) {
        return (Function2 & Serializable)(a, b) -> new BiTuple(keyMappingA.apply(a, b), keyMappingB.apply(a, b));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiConstraintCollector<A, B, ?, NewC> collectorC) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, inputA, (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutput)});
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutput);
        return new TriLeftHandSide(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), new PatternVariable(newC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(BiFunction<A, B, NewA> keyMappingA, BiFunction<A, B, NewB> keyMappingB, BiConstraintCollector<A, B, ?, NewC> collectorC, BiConstraintCollector<A, B, ?, NewD> collectorD) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<BiTuple> accumulateSource = this.variableFactory.createVariable(BiTuple.class, "source");
        PatternVariable<Object> newPatternVariableB = this.patternVariableB.bind(accumulateSource, inputA, (b, a) -> new BiTuple<Object, Object>(a, b));
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = BiLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, newPatternVariableB);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        Variable newD = this.variableFactory.createVariable("newD", accumulateOutputD);
        return new QuadLeftHandSide(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), new PatternVariable(newC), new PatternVariable(newD), this.variableFactory);
    }

    public AbstractBiConstraintConsequence<A, B> andTerminate() {
        return new BiConstraintDefaultConsequence(this);
    }

    public AbstractBiConstraintConsequence<A, B> andTerminate(ToIntBiFunction<A, B> matchWeighter) {
        return new BiConstraintIntConsequence<A, B>(this, matchWeighter);
    }

    public AbstractBiConstraintConsequence<A, B> andTerminate(ToLongBiFunction<A, B> matchWeighter) {
        return new BiConstraintLongConsequence<A, B>(this, matchWeighter);
    }

    public AbstractBiConstraintConsequence<A, B> andTerminate(BiFunction<A, B, BigDecimal> matchWeighter) {
        return new BiConstraintBigDecimalConsequence<A, B>(this, matchWeighter);
    }

    @Override
    public List<ViewItem<?>> get() {
        return Stream.of(this.patternVariableA, this.patternVariableB).flatMap(variable -> variable.build().stream()).collect(Collectors.toList());
    }

    @Override
    public Variable[] getVariables() {
        return (Variable[])Stream.of(this.patternVariableA, this.patternVariableB).map(PatternVariable::getPrimaryVariable).toArray(Variable[]::new);
    }
}

