/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.BetaIndex;
import org.drools.model.BetaIndex2;
import org.drools.model.BetaIndex3;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.Predicate4;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;

class PatternVariable<A> {
    private final Variable<A> primaryVariable;
    private final Supplier<PatternDSL.PatternDef<A>> patternSupplier;
    private final List<ViewItem<?>> prerequisiteExpressions;
    private final List<ViewItem<?>> dependentExpressions;

    PatternVariable(Variable<A> aVariable) {
        this(aVariable, Collections.emptyList());
    }

    PatternVariable(Variable<A> aVariable, List<ViewItem<?>> prerequisiteExpressions) {
        this.primaryVariable = aVariable;
        this.patternSupplier = () -> PatternDSL.pattern((Variable)aVariable);
        this.prerequisiteExpressions = prerequisiteExpressions;
        this.dependentExpressions = Collections.emptyList();
    }

    PatternVariable(PatternVariable<A> patternCreator, UnaryOperator<PatternDSL.PatternDef<A>> patternMutator) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.patternSupplier = () -> (PatternDSL.PatternDef)patternMutator.apply(patternCreator.patternSupplier.get());
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = patternCreator.dependentExpressions;
    }

    PatternVariable(PatternVariable<A> patternCreator, ViewItem<?> dependentExpression) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.patternSupplier = patternCreator.patternSupplier;
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = Stream.concat(patternCreator.dependentExpressions.stream(), Stream.of(dependentExpression)).collect(Collectors.toList());
    }

    public Variable<A> getPrimaryVariable() {
        return this.primaryVariable;
    }

    public PatternVariable<A> filter(Predicate<A> predicate) {
        return new PatternVariable<A>(this, p -> p.expr("Filter using " + predicate, predicate::test));
    }

    public <LeftJoinVar_> PatternVariable<A> filter(BiPredicate<LeftJoinVar_, A> predicate, Variable<LeftJoinVar_> leftJoinVariable) {
        return new PatternVariable<A>(this, p -> p.expr("Filter using " + predicate, leftJoinVariable, (Predicate2 & Serializable)(a, leftJoinVar) -> predicate.test(leftJoinVar, a)));
    }

    public <LeftJoinVarA_, LeftJoinVarB_> PatternVariable<A> filter(TriPredicate<LeftJoinVarA_, LeftJoinVarB_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB) {
        return new PatternVariable<A>(this, p -> p.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, (Predicate3 & Serializable)(a, leftJoinVarA, leftJoinVarB) -> predicate.test(leftJoinVarA, leftJoinVarB, a)));
    }

    public <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> PatternVariable<A> filter(QuadPredicate<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC) {
        return new PatternVariable<A>(this, p -> p.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, (Predicate4 & Serializable)(a, leftJoinVarA, leftJoinVarB, leftJoinVarC) -> predicate.test(leftJoinVarA, leftJoinVarB, leftJoinVarC, a)));
    }

    public <LeftJoinVar_> PatternVariable<A> filterForJoin(Variable<LeftJoinVar_> leftJoinVar, AbstractBiJoiner<LeftJoinVar_, A> joiner, JoinerType joinerType, int mappingIndex) {
        Function leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(leftMapping.apply(a), rightMapping.apply(b));
        return new PatternVariable<A>(this, p -> {
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVar, predicate, index);
        });
    }

    public <LeftJoinVarA_, LeftJoinVarB_> PatternVariable<A> filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, AbstractTriJoiner<LeftJoinVarA_, LeftJoinVarB_, A> joiner, JoinerType joinerType, int mappingIndex) {
        BiFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Predicate3 & Serializable predicate = (Predicate3 & Serializable)(c, a, b) -> joinerType.matches(leftMapping.apply(a, b), rightMapping.apply(c));
        return new PatternVariable<A>(this, p -> {
            BetaIndex2 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, predicate, index);
        });
    }

    public <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> PatternVariable<A> filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, Variable<LeftJoinVarC_> leftJoinVarC, AbstractQuadJoiner<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> joiner, JoinerType joinerType, int mappingIndex) {
        TriFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Predicate4 & Serializable predicate = (Predicate4 & Serializable)(d, a, b, c) -> joinerType.matches(leftMapping.apply(a, b, c), rightMapping.apply(d));
        return new PatternVariable<A>(this, p -> {
            BetaIndex3 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, leftJoinVarC, predicate, index);
        });
    }

    public <BoundVar_> PatternVariable<A> bind(Variable<BoundVar_> boundVariable, Function<A, BoundVar_> bindingFunction) {
        return new PatternVariable<A>(this, p -> p.bind(boundVariable, bindingFunction::apply));
    }

    public <BoundVar_, LeftJoinVar_> PatternVariable<A> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVar_> leftJoinVariable, BiFunction<A, LeftJoinVar_, BoundVar_> bindingFunction) {
        return new PatternVariable<A>(this, p -> p.bind(boundVariable, leftJoinVariable, bindingFunction::apply));
    }

    public <BoundVar_, LeftJoinVarA_, LeftJoinVarB_> PatternVariable<A> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, TriFunction<A, LeftJoinVarA_, LeftJoinVarB_, BoundVar_> bindingFunction) {
        return new PatternVariable<A>(this, p -> p.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, bindingFunction::apply));
    }

    public <BoundVar_, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> PatternVariable<A> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC, QuadFunction<A, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, BoundVar_> bindingFunction) {
        return new PatternVariable<A>(this, p -> p.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, bindingFunction::apply));
    }

    public PatternVariable<A> addDependentExpression(ViewItem<?> expression) {
        return new PatternVariable<A>(this, expression);
    }

    public List<ViewItem<?>> build() {
        Stream prerequisites = this.prerequisiteExpressions.stream();
        Stream dependents = this.dependentExpressions.stream();
        return Stream.concat(Stream.concat(prerequisites, Stream.of(this.patternSupplier.get())), dependents).collect(Collectors.toList());
    }
}

