/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.BetaIndex4;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function4;
import org.drools.model.functions.Predicate5;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.PentaPredicate;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractQuadConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.BiLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsQuadAccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadConstraintBigDecimalConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.QuadConstraintDefaultConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.QuadConstraintIntConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.QuadConstraintLongConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.UniLeftHandSide;
import org.optaplanner.core.impl.score.stream.penta.AbstractPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.FilteringPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.NonePentaJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class QuadLeftHandSide<A, B, C, D>
extends AbstractLeftHandSide {
    private final PatternVariable<A> patternVariableA;
    private final PatternVariable<B> patternVariableB;
    private final PatternVariable<C> patternVariableC;
    private final PatternVariable<D> patternVariableD;

    protected QuadLeftHandSide(PatternVariable<A> patternVariableA, PatternVariable<B> patternVariableB, PatternVariable<C> patternVariableC, PatternVariable<D> patternVariableD, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = patternVariableA;
        this.patternVariableB = patternVariableB;
        this.patternVariableC = patternVariableC;
        this.patternVariableD = patternVariableD;
    }

    protected QuadLeftHandSide(QuadLeftHandSide<A, B, C, D> leftHandSide, PatternVariable<D> patternVariable) {
        super(leftHandSide.variableFactory);
        this.patternVariableA = leftHandSide.patternVariableA;
        this.patternVariableB = leftHandSide.patternVariableB;
        this.patternVariableC = leftHandSide.patternVariableC;
        this.patternVariableD = patternVariable;
    }

    public QuadLeftHandSide<A, B, C, D> andFilter(QuadPredicate<A, B, C, D> predicate) {
        return new QuadLeftHandSide<A, B, C, D>(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD.filter(predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable()), this.variableFactory);
    }

    private <E> QuadLeftHandSide<A, B, C, D> applyJoiners(Class<E> otherFactType, AbstractPentaJoiner<A, B, C, D, E> joiner, PentaPredicate<A, B, C, D, E> predicate, boolean shouldExist) {
        Variable<E> toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            QuadFunction leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate5 & Serializable joinPredicate = (Predicate5 & Serializable)(e, a, b, c, d) -> joinerType.matches(leftMapping.apply(a, b, c, d), rightMapping.apply(e));
            BetaIndex4 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)QuadLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), (Predicate5)joinPredicate, index);
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <E> QuadLeftHandSide<A, B, C, D> applyFilters(PatternDSL.PatternDef<E> existencePattern, PentaPredicate<A, B, C, D, E> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), (Predicate5 & Serializable)(e, a, b, c, d) -> predicate.test(a, b, c, d, e));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new QuadLeftHandSide<A, B, C, D>(this, this.patternVariableD.addDependentExpression((ViewItem<?>)existenceExpression));
    }

    private <E> QuadLeftHandSide<A, B, C, D> existsOrNot(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        AbstractPentaJoiner finalJoiner = null;
        PentaPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractPentaJoiner joiner = (AbstractPentaJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NonePentaJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringPentaJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractPentaJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(dClass, finalJoiner, finalFilter, shouldExist);
    }

    public <E> QuadLeftHandSide<A, B, C, D> andExists(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners) {
        return this.existsOrNot(dClass, joiners, true);
    }

    public <E> QuadLeftHandSide<A, B, C, D> andNotExists(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners) {
        return this.existsOrNot(dClass, joiners, false);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMapping) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, keyMapping::apply, (AccumulateFunction[])new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        return new UniLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collector) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> innerAccumulatePattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collector, accumulateSource, accumulateOutput), (AccumulateFunction[])new AccumulateFunction[0]);
        return new UniLeftHandSide(new PatternVariable(accumulateOutput, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> innerAccumulatePattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB)});
        return new BiLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> innerAccumulatePattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC)});
        return new TriLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), new PatternVariable(accumulateOutputC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> innerAccumulatePattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        return new QuadLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), new PatternVariable(accumulateOutputC), new PatternVariable(accumulateOutputD), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(QuadConstraintCollector<A, B, C, D, ?, Out> collector, Variable<QuadTuple<A, B, C, D>> in, Variable<Out> out) {
        return DSL.accFunction(() -> new DroolsQuadAccumulateFunction(collector), in).as(out);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutput)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutput);
        return new BiLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutputB);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        return new TriLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), new PatternVariable(newC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutputB);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        Variable newD = this.variableFactory.createVariable("newD", accumulateOutputD);
        return new QuadLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), new PatternVariable(newC), new PatternVariable(newD), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[0]);
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        return new BiLeftHandSide<Object, Object>(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), this.variableFactory);
    }

    private <NewA, NewB> Function4<A, B, C, D, BiTuple<NewA, NewB>> createCompositeBiGroupKey(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB) {
        return (Function4 & Serializable)(a, b, c, d) -> new BiTuple(keyMappingA.apply(a, b, c, d), keyMappingB.apply(a, b, c, d));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutput)});
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutput);
        return new TriLeftHandSide(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), new PatternVariable(newC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        PatternVariable<Object> newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        Variable newD = this.variableFactory.createVariable("newD", accumulateOutputD);
        return new QuadLeftHandSide(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), new PatternVariable(newC), new PatternVariable(newD), this.variableFactory);
    }

    public AbstractQuadConstraintConsequence<A, B, C, D> andTerminate() {
        return new QuadConstraintDefaultConsequence(this);
    }

    public AbstractQuadConstraintConsequence<A, B, C, D> andTerminate(ToIntQuadFunction<A, B, C, D> matchWeighter) {
        return new QuadConstraintIntConsequence<A, B, C, D>(this, matchWeighter);
    }

    public AbstractQuadConstraintConsequence<A, B, C, D> andTerminate(ToLongQuadFunction<A, B, C, D> matchWeighter) {
        return new QuadConstraintLongConsequence<A, B, C, D>(this, matchWeighter);
    }

    public AbstractQuadConstraintConsequence<A, B, C, D> andTerminate(QuadFunction<A, B, C, D, BigDecimal> matchWeighter) {
        return new QuadConstraintBigDecimalConsequence<A, B, C, D>(this, matchWeighter);
    }

    @Override
    public List<ViewItem<?>> get() {
        return Stream.of(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD).flatMap(variable -> variable.build().stream()).collect(Collectors.toList());
    }

    @Override
    public Variable[] getVariables() {
        return (Variable[])Stream.of(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD).map(PatternVariable::getPrimaryVariable).toArray(Variable[]::new);
    }
}

