/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.BetaIndex3;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Predicate4;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractTriConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.BiLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsTriAccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.TriConstraintBigDecimalConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.TriConstraintDefaultConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.TriConstraintIntConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.TriConstraintLongConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.common.UniLeftHandSide;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.FilteringQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.NoneQuadJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class TriLeftHandSide<A, B, C>
extends AbstractLeftHandSide {
    private final PatternVariable<A> patternVariableA;
    private final PatternVariable<B> patternVariableB;
    private final PatternVariable<C> patternVariableC;

    protected TriLeftHandSide(PatternVariable<A> patternVariableA, PatternVariable<B> patternVariableB, PatternVariable<C> patternVariableC, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = patternVariableA;
        this.patternVariableB = patternVariableB;
        this.patternVariableC = patternVariableC;
    }

    protected TriLeftHandSide(TriLeftHandSide<A, B, C> leftHandSide, PatternVariable<C> patternVariable) {
        super(leftHandSide.variableFactory);
        this.patternVariableA = leftHandSide.patternVariableA;
        this.patternVariableB = leftHandSide.patternVariableB;
        this.patternVariableC = patternVariable;
    }

    protected PatternVariable<A> getPatternVariableA() {
        return this.patternVariableA;
    }

    protected PatternVariable<B> getPatternVariableB() {
        return this.patternVariableB;
    }

    protected PatternVariable<C> getPatternVariableC() {
        return this.patternVariableC;
    }

    public TriLeftHandSide<A, B, C> andFilter(TriPredicate<A, B, C> predicate) {
        return new TriLeftHandSide<A, B, C>(this.patternVariableA, this.patternVariableB, this.patternVariableC.filter(predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable()), this.variableFactory);
    }

    private <D> TriLeftHandSide<A, B, C> applyJoiners(Class<D> otherFactType, AbstractQuadJoiner<A, B, C, D> joiner, QuadPredicate<A, B, C, D> predicate, boolean shouldExist) {
        Variable<D> toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            TriFunction leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate4 & Serializable joinPredicate = (Predicate4 & Serializable)(d, a, b, c) -> joinerType.matches(leftMapping.apply(a, b, c), rightMapping.apply(d));
            BetaIndex3 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)TriLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (Predicate4)joinPredicate, index);
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <D> TriLeftHandSide<A, B, C> applyFilters(PatternDSL.PatternDef<D> existencePattern, QuadPredicate<A, B, C, D> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (Predicate4 & Serializable)(d, a, b, c) -> predicate.test(a, b, c, d));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new TriLeftHandSide<A, B, C>(this, this.patternVariableC.addDependentExpression((ViewItem<?>)existenceExpression));
    }

    private <D> TriLeftHandSide<A, B, C> existsOrNot(Class<D> dClass, QuadJoiner<A, B, C, D>[] joiners, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        AbstractQuadJoiner finalJoiner = null;
        QuadPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractQuadJoiner joiner = (AbstractQuadJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NoneQuadJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringQuadJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractQuadJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(dClass, finalJoiner, finalFilter, shouldExist);
    }

    public <D> TriLeftHandSide<A, B, C> andExists(Class<D> dClass, QuadJoiner<A, B, C, D>[] joiners) {
        return this.existsOrNot(dClass, joiners, true);
    }

    public <D> TriLeftHandSide<A, B, C> andNotExists(Class<D> dClass, QuadJoiner<A, B, C, D>[] joiners) {
        return this.existsOrNot(dClass, joiners, false);
    }

    public <D> QuadLeftHandSide<A, B, C, D> andJoin(UniLeftHandSide<D> right, QuadJoiner<A, B, C, D> joiner) {
        AbstractQuadJoiner castJoiner = (AbstractQuadJoiner)joiner;
        JoinerType[] joinerTypes = castJoiner.getJoinerTypes();
        PatternVariable<D> newRight = right.getPatternVariableA();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            newRight = newRight.filterForJoin(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), castJoiner, joinerType, mappingIndex);
        }
        return new QuadLeftHandSide<A, B, C, D>(this.patternVariableA, this.patternVariableB, this.patternVariableC, newRight, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(TriFunction<A, B, C, NewA> keyMapping) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> innerGroupByPattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, groupKey, keyMapping::apply, (AccumulateFunction[])new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        return new UniLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(TriConstraintCollector<A, B, C, ?, NewA> collector) {
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> innerAccumulatePattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collector, accumulateSource, accumulateOutput), (AccumulateFunction[])new AccumulateFunction[0]);
        return new UniLeftHandSide(new PatternVariable(accumulateOutput, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(TriConstraintCollector<A, B, C, ?, NewA> collectorA, TriConstraintCollector<A, B, C, ?, NewB> collectorB) {
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> innerAccumulatePattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB)});
        return new BiLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(TriConstraintCollector<A, B, C, ?, NewA> collectorA, TriConstraintCollector<A, B, C, ?, NewB> collectorB, TriConstraintCollector<A, B, C, ?, NewC> collectorC) {
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> innerAccumulatePattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC)});
        return new TriLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), new PatternVariable(accumulateOutputC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(TriConstraintCollector<A, B, C, ?, NewA> collectorA, TriConstraintCollector<A, B, C, ?, NewB> collectorB, TriConstraintCollector<A, B, C, ?, NewC> collectorC, TriConstraintCollector<A, B, C, ?, NewD> collectorD) {
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> innerAccumulatePattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        return new QuadLeftHandSide(new PatternVariable(accumulateOutputA, Collections.singletonList(outerAccumulatePattern)), new PatternVariable(accumulateOutputB), new PatternVariable(accumulateOutputC), new PatternVariable(accumulateOutputD), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(TriConstraintCollector<A, B, C, ?, Out> collector, Variable<TriTuple<A, B, C>> in, Variable<Out> out) {
        return DSL.accFunction(() -> new DroolsTriAccumulateFunction(collector), in).as(out);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriConstraintCollector<A, B, C, ?, NewB> collectorB) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutput)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutput);
        return new BiLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriConstraintCollector<A, B, C, ?, NewB> collectorB, TriConstraintCollector<A, B, C, ?, NewC> collectorC) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> innerGroupByPattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutputB);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        return new TriLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), new PatternVariable(newC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriConstraintCollector<A, B, C, ?, NewB> collectorB, TriConstraintCollector<A, B, C, ?, NewC> collectorC, TriConstraintCollector<A, B, C, ?, NewD> collectorD) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutputB);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        Variable newD = this.variableFactory.createVariable("newD", accumulateOutputD);
        return new QuadLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), new PatternVariable(newC), new PatternVariable(newD), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> innerGroupByPattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[0]);
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        return new BiLeftHandSide<Object, Object>(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), this.variableFactory);
    }

    private <NewA, NewB> Function3<A, B, C, BiTuple<NewA, NewB>> createCompositeBiGroupKey(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB) {
        return (Function3 & Serializable)(a, b, c) -> new BiTuple(keyMappingA.apply(a, b, c), keyMappingB.apply(a, b, c));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriConstraintCollector<A, B, C, ?, NewC> collectorC) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutput)});
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutput);
        return new TriLeftHandSide(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), new PatternVariable(newC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriConstraintCollector<A, B, C, ?, NewC> collectorC, TriConstraintCollector<A, B, C, ?, NewD> collectorD) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<TriTuple> accumulateSource = this.variableFactory.createVariable(TriTuple.class, "source");
        PatternVariable<Object> newPatternVariableC = this.patternVariableC.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), (c, a, b) -> new TriTuple<Object, Object, Object>(a, b, c));
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, newPatternVariableC);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD)});
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        Variable newD = this.variableFactory.createVariable("newD", accumulateOutputD);
        return new QuadLeftHandSide(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), new PatternVariable(newC), new PatternVariable(newD), this.variableFactory);
    }

    public AbstractTriConstraintConsequence<A, B, C> andTerminate() {
        return new TriConstraintDefaultConsequence(this);
    }

    public AbstractTriConstraintConsequence<A, B, C> andTerminate(ToIntTriFunction<A, B, C> matchWeighter) {
        return new TriConstraintIntConsequence<A, B, C>(this, matchWeighter);
    }

    public AbstractTriConstraintConsequence<A, B, C> andTerminate(ToLongTriFunction<A, B, C> matchWeighter) {
        return new TriConstraintLongConsequence<A, B, C>(this, matchWeighter);
    }

    public AbstractTriConstraintConsequence<A, B, C> andTerminate(TriFunction<A, B, C, BigDecimal> matchWeighter) {
        return new TriConstraintBigDecimalConsequence<A, B, C>(this, matchWeighter);
    }

    @Override
    public List<ViewItem<?>> get() {
        return Stream.of(this.patternVariableA, this.patternVariableB, this.patternVariableC).flatMap(variable -> variable.build().stream()).collect(Collectors.toList());
    }

    @Override
    public Variable[] getVariables() {
        return (Variable[])Stream.of(this.patternVariableA, this.patternVariableB, this.patternVariableC).map(PatternVariable::getPrimaryVariable).toArray(Variable[]::new);
    }
}

