/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.math.BigDecimal;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsGroupingBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractTriConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsGroupingQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsJoinQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsExistsTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsFilterTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsGroupingTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsGroupingUniConstraintStream;
import org.optaplanner.core.impl.score.stream.quad.FilteringQuadJoiner;
import org.optaplanner.core.impl.score.stream.tri.InnerTriConstraintStream;

public abstract class DroolsAbstractTriConstraintStream<Solution_, A, B, C>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerTriConstraintStream<A, B, C> {
    public DroolsAbstractTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory) {
        super(constraintFactory);
    }

    @Override
    public int getCardinality() {
        return 3;
    }

    @Override
    public TriConstraintStream<A, B, C> filter(TriPredicate<A, B, C> predicate) {
        DroolsFilterTriConstraintStream stream = new DroolsFilterTriConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <D> QuadConstraintStream<A, B, C, D> join(UniConstraintStream<D> otherStream, QuadJoiner<A, B, C, D> joiner) {
        if (joiner instanceof FilteringQuadJoiner) {
            return this.join(otherStream).filter(((FilteringQuadJoiner)joiner).getFilter());
        }
        DroolsJoinQuadConstraintStream stream = new DroolsJoinQuadConstraintStream(this.constraintFactory, this, (DroolsAbstractUniConstraintStream)otherStream, joiner);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    @SafeVarargs
    public final <D> TriConstraintStream<A, B, C> ifExists(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return this.ifExistsOrNot(true, otherClass, joiners);
    }

    @Override
    @SafeVarargs
    public final <D> TriConstraintStream<A, B, C> ifNotExists(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return this.ifExistsOrNot(false, otherClass, joiners);
    }

    @SafeVarargs
    private final <D> TriConstraintStream<A, B, C> ifExistsOrNot(boolean shouldExist, Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        this.getConstraintFactory().assertValidFromType(otherClass);
        DroolsExistsTriConstraintStream stream = new DroolsExistsTriConstraintStream(this.constraintFactory, this, shouldExist, otherClass, joiners);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(TriConstraintCollector<A, B, C, ResultContainer_, Result_> collector) {
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> collectorA, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, collectorA, collectorB);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> collectorA, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, collectorA, collectorB, collectorC);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> collectorA, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, collectorA, collectorB, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(TriFunction<A, B, C, GroupKey_> groupKeyMapping) {
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, groupKeyMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(TriFunction<A, B, C, GroupKey_> groupKeyMapping, TriConstraintCollector<A, B, C, ResultContainer_, Result_> collector) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(TriFunction<A, B, C, GroupKey_> groupKeyMapping, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyMapping, collectorB, collectorC);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(TriFunction<A, B, C, GroupKey_> groupKeyMapping, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyMapping, collectorB, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping, TriConstraintCollector<A, B, C, ResultContainer_, Result_> collector) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    protected Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType) {
        AbstractTriConstraintConsequence<A, B, C> consequence = this.getLeftHandSide().andTerminate();
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, consequence);
    }

    @Override
    public Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher, ScoreImpactType impactType) {
        AbstractTriConstraintConsequence<A, B, C> consequence = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, consequence);
    }

    @Override
    public Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher, ScoreImpactType impactType) {
        AbstractTriConstraintConsequence<A, B, C> consequence = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, consequence);
    }

    @Override
    public Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        AbstractTriConstraintConsequence<A, B, C> consequence = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, consequence);
    }

    @Override
    protected Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType) {
        AbstractTriConstraintConsequence<A, B, C> consequence = this.getLeftHandSide().andTerminate();
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, consequence);
    }

    @Override
    public Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntTriFunction<A, B, C> matchWeigher, ScoreImpactType impactType) {
        AbstractTriConstraintConsequence<A, B, C> consequence = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, consequence);
    }

    @Override
    public Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongTriFunction<A, B, C> matchWeigher, ScoreImpactType impactType) {
        AbstractTriConstraintConsequence<A, B, C> consequence = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, consequence);
    }

    @Override
    public Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, TriFunction<A, B, C, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        AbstractTriConstraintConsequence<A, B, C> consequence = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, consequence);
    }

    public abstract TriLeftHandSide<A, B, C> getLeftHandSide();
}

