/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.stepcountinghillclimbing;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.localsearch.decider.acceptor.stepcountinghillclimbing.StepCountingHillClimbingType;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;

public class StepCountingHillClimbingAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected int stepCountingHillClimbingSize = -1;
    protected StepCountingHillClimbingType stepCountingHillClimbingType;
    protected Score thresholdScore;
    protected int count = -1;

    public StepCountingHillClimbingAcceptor(int stepCountingHillClimbingSize, StepCountingHillClimbingType stepCountingHillClimbingType) {
        this.stepCountingHillClimbingSize = stepCountingHillClimbingSize;
        this.stepCountingHillClimbingType = stepCountingHillClimbingType;
        if (stepCountingHillClimbingSize <= 0) {
            throw new IllegalArgumentException("The stepCountingHillClimbingSize (" + stepCountingHillClimbingSize + ") cannot be negative or zero.");
        }
        if (stepCountingHillClimbingType == null) {
            throw new IllegalArgumentException("The stepCountingHillClimbingType (" + (Object)((Object)stepCountingHillClimbingType) + ") cannot be null.");
        }
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.thresholdScore = phaseScope.getBestScore();
        this.count = 0;
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        Score<?> lastStepScore = ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
        Object moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) >= 0) {
            return true;
        }
        return moveScore.compareTo((Score)this.thresholdScore) >= 0;
    }

    @Override
    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.count += this.determineCountIncrement(stepScope);
        if (this.count >= this.stepCountingHillClimbingSize) {
            this.thresholdScore = stepScope.getScore();
            this.count = 0;
        }
    }

    private int determineCountIncrement(LocalSearchStepScope<Solution_> stepScope) {
        switch (this.stepCountingHillClimbingType) {
            case SELECTED_MOVE: {
                long selectedMoveCount = stepScope.getSelectedMoveCount();
                return selectedMoveCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)selectedMoveCount;
            }
            case ACCEPTED_MOVE: {
                long acceptedMoveCount = stepScope.getAcceptedMoveCount();
                return acceptedMoveCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)acceptedMoveCount;
            }
            case STEP: {
                return 1;
            }
            case EQUAL_OR_IMPROVING_STEP: {
                return stepScope.getScore().compareTo(((LocalSearchPhaseScope)stepScope.getPhaseScope()).getLastCompletedStepScope().getScore()) >= 0 ? 1 : 0;
            }
            case IMPROVING_STEP: {
                return stepScope.getScore().compareTo(((LocalSearchPhaseScope)stepScope.getPhaseScope()).getLastCompletedStepScope().getScore()) > 0 ? 1 : 0;
            }
        }
        throw new IllegalStateException("The stepCountingHillClimbingType (" + (Object)((Object)this.stepCountingHillClimbingType) + ") is not implemented.");
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.thresholdScore = null;
        this.count = -1;
    }
}

