/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.drools.model.BetaIndex4;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function4;
import org.drools.model.functions.Predicate5;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.PentaPredicate;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DetachedPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.DirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.IndirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadAccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.QuadRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.RuleBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.TriRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.common.UniLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.UniRuleContext;
import org.optaplanner.core.impl.score.stream.penta.AbstractPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.FilteringPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.NonePentaJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class QuadLeftHandSide<A, B, C, D>
extends AbstractLeftHandSide {
    private final PatternVariable<A, ?, ?> patternVariableA;
    private final PatternVariable<B, ?, ?> patternVariableB;
    private final PatternVariable<C, ?, ?> patternVariableC;
    private final PatternVariable<D, ?, ?> patternVariableD;
    private final QuadRuleContext<A, B, C, D> ruleContext;

    protected QuadLeftHandSide(PatternVariable<A, ?, ?> patternVariableA, PatternVariable<B, ?, ?> patternVariableB, PatternVariable<C, ?, ?> patternVariableC, PatternVariable<D, ?, ?> patternVariableD, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = patternVariableA;
        this.patternVariableB = patternVariableB;
        this.patternVariableC = patternVariableC;
        this.patternVariableD = patternVariableD;
        this.ruleContext = this.buildDefaultRuleContext();
    }

    protected QuadLeftHandSide(QuadRuleContext<A, B, C, D> ruleContext, PatternVariable<A, ?, ?> patternVariableA, PatternVariable<B, ?, ?> patternVariableB, PatternVariable<C, ?, ?> patternVariableC, PatternVariable<D, ?, ?> patternVariableD, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = patternVariableA;
        this.patternVariableB = patternVariableB;
        this.patternVariableC = patternVariableC;
        this.patternVariableD = patternVariableD;
        this.ruleContext = Objects.requireNonNull(ruleContext);
    }

    protected QuadLeftHandSide(QuadLeftHandSide<A, B, C, D> leftHandSide, PatternVariable<D, ?, ?> patternVariable) {
        super(leftHandSide.variableFactory);
        this.patternVariableA = leftHandSide.patternVariableA;
        this.patternVariableB = leftHandSide.patternVariableB;
        this.patternVariableC = leftHandSide.patternVariableC;
        this.patternVariableD = patternVariable;
        this.ruleContext = this.buildDefaultRuleContext();
    }

    private QuadRuleContext<A, B, C, D> buildDefaultRuleContext() {
        ViewItem[] viewItems = (ViewItem[])Stream.of(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD).flatMap(variable -> variable.build().stream()).toArray(ViewItem[]::new);
        return new QuadRuleContext<A, B, C, D>(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), viewItems);
    }

    public QuadLeftHandSide<A, B, C, D> andFilter(QuadPredicate<A, B, C, D> predicate) {
        return new QuadLeftHandSide<A, B, C, D>(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD.filter(predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable()), this.variableFactory);
    }

    private <E> QuadLeftHandSide<A, B, C, D> applyJoiners(Class<E> otherFactType, AbstractPentaJoiner<A, B, C, D, E> joiner, PentaPredicate<A, B, C, D, E> predicate, boolean shouldExist) {
        Variable<E> toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            QuadFunction leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate5 & Serializable joinPredicate = (Predicate5 & Serializable)(e, a, b, c, d) -> joinerType.matches(leftMapping.apply(a, b, c, d), rightMapping.apply(e));
            BetaIndex4 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)QuadLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), (Predicate5)joinPredicate, index);
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <E> QuadLeftHandSide<A, B, C, D> applyFilters(PatternDSL.PatternDef<E> existencePattern, PentaPredicate<A, B, C, D, E> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), (Predicate5 & Serializable)(e, a, b, c, d) -> predicate.test(a, b, c, d, e));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new QuadLeftHandSide<A, B, C, D>(this, this.patternVariableD.addDependentExpression((ViewItem<?>)existenceExpression));
    }

    private <E> QuadLeftHandSide<A, B, C, D> existsOrNot(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        AbstractPentaJoiner finalJoiner = null;
        PentaPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractPentaJoiner joiner = (AbstractPentaJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NonePentaJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringPentaJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractPentaJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(dClass, finalJoiner, finalFilter, shouldExist);
    }

    public <E> QuadLeftHandSide<A, B, C, D> andExists(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners) {
        return this.existsOrNot(dClass, joiners, true);
    }

    public <E> QuadLeftHandSide<A, B, C, D> andNotExists(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners) {
        return this.existsOrNot(dClass, joiners, false);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collector) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(accumulateSource, this.createAccumulateFunction(collector, accumulateSource, accumulateOutput));
        UniRuleContext simpleRuleContext = new UniRuleContext(accumulateOutput, outerAccumulatePattern);
        return new UniLeftHandSide(simpleRuleContext, new DirectPatternVariable(accumulateOutput, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(accumulateSource, this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB));
        BiRuleContext simpleRuleContext = new BiRuleContext(accumulateOutputA, accumulateOutputB, outerAccumulatePattern);
        return new BiLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DirectPatternVariable(accumulateOutputB, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(accumulateSource, this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC));
        TriRuleContext simpleRuleContext = new TriRuleContext(accumulateOutputA, accumulateOutputB, accumulateOutputC, outerAccumulatePattern);
        return new TriLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DetachedPatternVariable(accumulateOutputB), new DirectPatternVariable(accumulateOutputC, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(accumulateSource, this.createAccumulateFunction(collectorA, accumulateSource, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD));
        QuadRuleContext simpleRuleContext = new QuadRuleContext(accumulateOutputA, accumulateOutputB, accumulateOutputC, accumulateOutputD, outerAccumulatePattern);
        return new QuadLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DetachedPatternVariable(accumulateOutputB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(QuadConstraintCollector<A, B, C, D, ?, Out> collector, Variable<QuadTuple<A, B, C, D>> in, Variable<Out> out) {
        return DSL.accFunction(() -> new QuadAccumulateFunction(collector), in).as(out);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMapping) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMapping::apply);
        UniRuleContext simpleRuleContext = new UniRuleContext(groupKey, groupByPattern);
        return new UniLeftHandSide(simpleRuleContext, new DirectPatternVariable(groupKey, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutput));
        BiRuleContext simpleRuleContext = new BiRuleContext(groupKey, accumulateOutput, groupByPattern);
        return new BiLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DirectPatternVariable(accumulateOutput, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC));
        TriRuleContext simpleRuleContext = new TriRuleContext(groupKey, accumulateOutputB, accumulateOutputC, groupByPattern);
        return new TriLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DetachedPatternVariable(accumulateOutputB), new DirectPatternVariable(accumulateOutputC, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateSource, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD));
        QuadRuleContext simpleRuleContext = new QuadRuleContext(groupKey, accumulateOutputB, accumulateOutputC, accumulateOutputD, groupByPattern);
        return new QuadLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DetachedPatternVariable(accumulateOutputB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB) {
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        IndirectPatternVariable<Object, BiTuple> bPatternVar = new IndirectPatternVariable<Object, BiTuple>(tuplePatternVar, newB, tuple -> tuple.b);
        return new BiLeftHandSide(new DetachedPatternVariable(newA), bPatternVar, this.variableFactory);
    }

    private <NewA, NewB> Function4<A, B, C, D, BiTuple<NewA, NewB>> createCompositeBiGroupKey(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB) {
        return (Function4 & Serializable)(a, b, c, d) -> new BiTuple(keyMappingA.apply(a, b, c, d), keyMappingB.apply(a, b, c, d));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutput));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        List<ViewItem<?>> prerequisites = tuplePatternVar.build();
        return new TriLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DirectPatternVariable(accumulateOutput, prerequisites), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), this.createAccumulateFunction(collectorC, accumulateSource, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        List<ViewItem<?>> prerequisites = tuplePatternVar.build();
        return new QuadLeftHandSide<A, B, C, D>(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, prerequisites), this.variableFactory);
    }

    private <NewA, NewB, NewC> Function4<A, B, C, D, TriTuple<NewA, NewB, NewC>> createCompositeTriGroupKey(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC) {
        return (Function4 & Serializable)(a, b, c, d) -> new TriTuple(keyMappingA.apply(a, b, c, d), keyMappingB.apply(a, b, c, d), keyMappingC.apply(a, b, c, d));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC) {
        Variable<TriTuple> groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeTriGroupKey(keyMappingA, keyMappingB, keyMappingC));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        DirectPatternVariable tuplePatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC);
        IndirectPatternVariable<Object, TriTuple> cPatternVar = new IndirectPatternVariable<Object, TriTuple>(tuplePatternVar, newC, tuple -> tuple.c);
        return new TriLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), cPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable<QuadTuple> accumulateSource = this.variableFactory.createVariable(QuadTuple.class, "source");
        Variable<TriTuple> groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(accumulateSource, groupKey, this.createCompositeTriGroupKey(keyMappingA, keyMappingB, keyMappingC), this.createAccumulateFunction(collectorD, accumulateSource, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        DirectPatternVariable tuplePatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC);
        List<ViewItem<?>> prerequisites = tuplePatternVar.build();
        return new QuadLeftHandSide<A, B, C, D>(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DetachedPatternVariable(newC), new DirectPatternVariable(accumulateOutputD, prerequisites), this.variableFactory);
    }

    private <NewA, NewB, NewC, NewD> Function4<A, B, C, D, QuadTuple<NewA, NewB, NewC, NewD>> createCompositeQuadGroupKey(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC, QuadFunction<A, B, C, D, NewD> keyMappingD) {
        return (Function4 & Serializable)(a, b, c, d) -> new QuadTuple(keyMappingA.apply(a, b, c, d), keyMappingB.apply(a, b, c, d), keyMappingC.apply(a, b, c, d), keyMappingD.apply(a, b, c, d));
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC, QuadFunction<A, B, C, D, NewD> keyMappingD) {
        Variable<QuadTuple> groupKey = this.variableFactory.createVariable(QuadTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeQuadGroupKey(keyMappingA, keyMappingB, keyMappingC, keyMappingD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        Variable newD = this.variableFactory.createVariable("newD");
        DirectPatternVariable tuplePatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC, newD);
        IndirectPatternVariable<Object, QuadTuple> dPatternVar = new IndirectPatternVariable<Object, QuadTuple>(tuplePatternVar, newD, tuple -> tuple.d);
        return new QuadLeftHandSide<A, B, C, D>(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DetachedPatternVariable(newC), dPatternVar, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andMap(QuadFunction<A, B, C, D, NewA> mapping) {
        Variable<NewA> newA = this.variableFactory.createVariable("mapped", this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), mapping);
        List<ViewItem<?>> allPrerequisites = QuadLeftHandSide.mergeViewItems(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD);
        DirectPatternVariable<NewA> newPatternVariableA = new DirectPatternVariable<NewA>(newA, allPrerequisites);
        return new UniLeftHandSide(this, newPatternVariableA);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate() {
        return this.ruleContext.newRuleBuilder();
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToIntQuadFunction<A, B, C, D> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToLongQuadFunction<A, B, C, D> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(QuadFunction<A, B, C, D, BigDecimal> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    private ViewItem<?> buildAccumulate(Variable<QuadTuple<A, B, C, D>> accumulateSource, AccumulateFunction ... accFunctions) {
        Object newPatternVariableD = this.patternVariableD.bind(accumulateSource, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        ViewItem<?> innerAccumulatePattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(new PatternVariable[]{this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD});
        return QuadLeftHandSide.buildAccumulate(innerAccumulatePattern, accFunctions);
    }

    private <GroupKey_> ViewItem<?> buildGroupBy(Variable<GroupKey_> groupKey, Function4<A, B, C, D, GroupKey_> groupKeyExtractor) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD);
        return DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, groupKeyExtractor, (AccumulateFunction[])new AccumulateFunction[0]);
    }

    private <GroupKey_> ViewItem<?> buildGroupBy(Variable<QuadTuple<A, B, C, D>> accumulateSource, Variable<GroupKey_> groupKey, Function4<A, B, C, D, GroupKey_> groupKeyExtractor, AccumulateFunction ... accFunctions) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        Object newPatternVariableD = this.patternVariableD.bind(accumulateSource, inputA, inputB, inputC, (d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d));
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(new PatternVariable[]{this.patternVariableA, this.patternVariableB, this.patternVariableC, newPatternVariableD});
        return DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, groupKeyExtractor, (AccumulateFunction[])accFunctions);
    }
}

