/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.CollectionInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.CollectionInverseVariableListener;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableListener;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class InverseRelationShadowVariableDescriptor<Solution_>
extends ShadowVariableDescriptor<Solution_> {
    protected VariableDescriptor<Solution_> sourceVariableDescriptor;
    protected boolean singleton;

    public InverseRelationShadowVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.linkShadowSources(descriptorPolicy);
    }

    private void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        boolean chained;
        Class<?> sourceClass;
        InverseRelationShadowVariable shadowVariableAnnotation = this.variableMemberAccessor.getAnnotation(InverseRelationShadowVariable.class);
        Class<?> variablePropertyType = this.getVariablePropertyType();
        if (Collection.class.isAssignableFrom(variablePropertyType)) {
            Type genericType = this.variableMemberAccessor.getGenericType();
            sourceClass = ConfigUtils.extractCollectionGenericTypeParameter("entityClass", this.entityDescriptor.getEntityClass(), variablePropertyType, genericType, InverseRelationShadowVariable.class, this.variableMemberAccessor.getName());
            this.singleton = false;
        } else {
            sourceClass = variablePropertyType;
            this.singleton = true;
        }
        EntityDescriptor sourceEntityDescriptor = this.getEntityDescriptor().getSolutionDescriptor().findEntityDescriptor(sourceClass);
        if (sourceEntityDescriptor == null) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a sourceClass (" + sourceClass + ") which is not a valid planning entity.");
        }
        String sourceVariableName = shadowVariableAnnotation.sourceVariableName();
        this.sourceVariableDescriptor = sourceEntityDescriptor.getVariableDescriptor(sourceVariableName);
        if (this.sourceVariableDescriptor == null) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on entityClass (" + sourceEntityDescriptor.getEntityClass() + ").\n" + this.entityDescriptor.buildInvalidVariableNameExceptionMessage(sourceVariableName));
        }
        boolean bl = chained = this.sourceVariableDescriptor instanceof GenuineVariableDescriptor && ((GenuineVariableDescriptor)this.sourceVariableDescriptor).isChained();
        if (this.singleton) {
            if (!chained) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") which does not return a " + Collection.class.getSimpleName() + " with sourceVariableName (" + sourceVariableName + ") which is not chained. Only a chained variable supports a singleton inverse.");
            }
        } else if (chained) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") which does returns a " + Collection.class.getSimpleName() + " with sourceVariableName (" + sourceVariableName + ") which is chained. A chained variable supports only a singleton inverse.");
        }
        this.sourceVariableDescriptor.registerSinkVariableDescriptor(this);
    }

    @Override
    public List<VariableDescriptor<Solution_>> getSourceVariableDescriptorList() {
        return Collections.singletonList(this.sourceVariableDescriptor);
    }

    @Override
    public Class<? extends VariableListener> getVariableListenerClass() {
        if (this.singleton) {
            return SingletonInverseVariableListener.class;
        }
        return CollectionInverseVariableListener.class;
    }

    @Override
    public Demand<Solution_, ?> getProvidedDemand() {
        if (this.singleton) {
            return new SingletonInverseVariableDemand<Solution_>(this.sourceVariableDescriptor);
        }
        return new CollectionInverseVariableDemand<Solution_>(this.sourceVariableDescriptor);
    }

    @Override
    public VariableListener<Solution_, ?> buildVariableListener(InnerScoreDirector<Solution_, ?> scoreDirector) {
        if (this.singleton) {
            return new SingletonInverseVariableListener<Solution_>(this, this.sourceVariableDescriptor);
        }
        return new CollectionInverseVariableListener<Solution_>(this, this.sourceVariableDescriptor);
    }
}

